set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8915610';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-8-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      NULL,
      NULL,
      '0034112',
      4.440416,
      0,
      NULL,
      0,
      '114311',
      NULL,
      ' 4-19-1983',
      50.803418,
      NULL,
      0,
      NULL,
      NULL,
      1.779309,
      0,
      1.250972,
      0.314607,
      2,
      NULL,
      0.375370,
      2,
      0.166413,
      1,
      0.983876,
      0,
      1.228111,
      0.232684,
      1,
      NULL,
      NULL,
      1.010621,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.574521,
      NULL,
      1,
      1,
      1.271976,
      NULL,
      0,
      1,
      1.151081,
      1,
      1.792116,
      0,
      0.168657,
      1,
      1,
      1,
      NULL,
      1.351122,
      0.369984,
      NULL,
      0.581765,
      3.498050,
      1,
      0,
      NULL,
      1.127509,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.110983,
      0.191725,
      0.246197,
      0.500265,
      0,
      0.542148,
      1,
      0.780567,
      1,
      1.761770,
      NULL,
      1.086923,
      1,
      1,
      NULL,
      1.532569,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.775929,
      2,
      NULL,
      2,
      1.703793,
      NULL,
      1.247250,
      3.145095,
      NULL,
      6,
      1.181295,
      1,
      4,
      0.917694,
      0.117245,
      NULL,
      0,
      9.728401,
      7,
      7,
      3.500865,
      2.642825,
      3.942951,
      2,
      NULL,
      NULL,
      1,
      1.163556,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.963001,
      0,
      0,
      1,
      0,
      0.750737,
      0.206351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.973563,
      NULL,
      NULL,
      NULL,
      NULL,
      1.959842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.229750,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      3.799377,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.351000,
      3,
      0.995747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.183602,
      0.627667,
      1.622255,
      0,
      2.836146,
      2,
      2,
      2.229143,
      1,
      2,
      NULL,
      0,
      1,
      1,
      1.792266,
      1.578615,
      NULL,
      NULL,
      0,
      0.371973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.273147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '01332',
      '',
      '',
      1.285749,
      '',
      '',
      '',
      0.230394,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


