set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8721162';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4420',
      NULL,
      16,
      NULL,
      '2412331',
      13.573548,
      2,
      3,
      0,
      '010334',
      1.419872,
      '11-24-1988',
      51.565503,
      12.763635,
      NULL,
      NULL,
      0,
      NULL,
      0.941667,
      1,
      1.325480,
      NULL,
      0,
      NULL,
      1.115381,
      1,
      0.019167,
      1.594786,
      5.794176,
      0,
      9.750253,
      NULL,
      5.914297,
      NULL,
      1.601481,
      0,
      3,
      0.331476,
      3.206255,
      1,
      3.804626,
      1,
      3.194108,
      0.671216,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.126800,
      7.283398,
      NULL,
      3.403136,
      2,
      0,
      0.776495,
      NULL,
      1.364015,
      NULL,
      1.398809,
      1,
      2.151428,
      1.548947,
      1,
      0,
      2,
      1,
      0,
      0.612986,
      0.183113,
      3,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.779300,
      NULL,
      NULL,
      1,
      7,
      2,
      NULL,
      NULL,
      0.319476,
      2.620085,
      1.060330,
      1.629003,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.230353,
      1.749681,
      NULL,
      NULL,
      0,
      NULL,
      0.184584,
      2.478130,
      1.973850,
      2.705041,
      0,
      NULL,
      0,
      1,
      2.823898,
      0,
      1,
      1,
      2.734058,
      0,
      1.443117,
      NULL,
      NULL,
      1.630240,
      6,
      5,
      7,
      5,
      7.874043,
      4,
      8,
      0.663729,
      NULL,
      NULL,
      1.028876,
      NULL,
      0.346952,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.587734,
      0.577475,
      NULL,
      NULL,
      0.472947,
      0,
      0.610155,
      0.454693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      6,
      NULL,
      3.157031,
      5.895416,
      3.577484,
      3,
      0.543753,
      1.526250,
      2.605236,
      NULL,
      0.865981,
      0.308646,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.661120,
      NULL,
      5,
      2,
      1.679267,
      1.351121,
      NULL,
      NULL,
      1,
      NULL,
      1.366811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.959962,
      NULL,
      NULL,
      3,
      1,
      2,
      3.311243,
      3,
      0.930207,
      3.955461,
      1,
      1.908263,
      1.231154,
      1,
      1,
      NULL,
      0,
      1.816671,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.287180,
      0.297074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.985057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      2,
      '10124',
      '12012',
      NULL,
      1.300889,
      '3144',
      '01214',
      '',
      1,
      NULL,
      '',
      '',
      5.872175,
      NULL,
      3.442135,
      3,
      5.474393,
      5.594311,
      1,
      0,
      1.676926);
commit;
end;
/


