set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8721162';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '40034411',
      62,
      NULL,
      '0030102',
      NULL,
      4,
      1,
      0,
      '013212',
      6,
      '11-13-1990',
      3,
      34.465523,
      1.776961,
      NULL,
      0.102932,
      0,
      3,
      1,
      1,
      3,
      2.020685,
      2.179724,
      0.945044,
      1,
      0,
      0.572418,
      5,
      1,
      4,
      0,
      5.917330,
      1.462923,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      2,
      2,
      0.425569,
      0,
      NULL,
      NULL,
      1.321484,
      NULL,
      NULL,
      2.234884,
      NULL,
      1,
      0,
      NULL,
      1,
      2.655726,
      0.582676,
      0,
      0,
      NULL,
      NULL,
      3.419974,
      1,
      3,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.168856,
      1,
      1,
      3.352820,
      0.103966,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.174215,
      0.822667,
      0.904527,
      NULL,
      5.623303,
      4.359681,
      4.416043,
      0.947102,
      0.424883,
      2.957114,
      0.316445,
      NULL,
      1.853476,
      3,
      NULL,
      0.884376,
      0.928550,
      0.638402,
      0,
      NULL,
      NULL,
      0.042527,
      1,
      1,
      0.476404,
      1.484715,
      1,
      0,
      1,
      NULL,
      2.656566,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.713119,
      4,
      3.289491,
      5,
      4,
      1.995836,
      3,
      0,
      NULL,
      1.505090,
      4.667622,
      2.346338,
      0,
      NULL,
      NULL,
      1.744019,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.742231,
      NULL,
      1,
      1,
      1.600694,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.583015,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      1,
      1.813215,
      2.876663,
      3.641966,
      2,
      1,
      NULL,
      NULL,
      NULL,
      5.920066,
      0,
      4,
      0.927855,
      0.147513,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.249222,
      NULL,
      1.117866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.158434,
      2,
      0,
      3,
      1,
      1.160138,
      1.755506,
      1.168496,
      1,
      NULL,
      NULL,
      1,
      0.337569,
      NULL,
      0,
      1.742876,
      1.560017,
      0.653713,
      1.553188,
      0.581766,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      '33012',
      '33101',
      NULL,
      0.420672,
      '0314',
      '01242',
      '',
      NULL,
      '',
      '',
      '',
      0,
      1.030798,
      NULL,
      1,
      1,
      0.487377,
      0,
      3,
      3);
commit;
end;
/


