set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502500';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-3-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      NULL,
      NULL,
      '0331401',
      12.497621,
      6,
      1,
      2,
      NULL,
      0.341791,
      ' 5-20-1988',
      16,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.314541,
      0,
      3.759173,
      NULL,
      2,
      1,
      0,
      1.469584,
      6,
      NULL,
      4,
      0.672886,
      0,
      NULL,
      8.900064,
      0.036311,
      1.640125,
      0.813946,
      1,
      0,
      2.275670,
      1,
      5.599518,
      1.247321,
      1.071186,
      1.967787,
      NULL,
      NULL,
      NULL,
      0.667122,
      5.678861,
      NULL,
      0,
      NULL,
      1.304694,
      1.802421,
      0,
      2.600149,
      3.909004,
      1,
      1.655080,
      3,
      2.026095,
      1.909081,
      2.075216,
      0,
      0.705770,
      0,
      1,
      NULL,
      NULL,
      0,
      1.861824,
      0.117121,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      2.422727,
      NULL,
      NULL,
      0.389414,
      NULL,
      0,
      NULL,
      NULL,
      4.239086,
      NULL,
      1.742382,
      0.163302,
      NULL,
      0.352549,
      0,
      NULL,
      2.793115,
      1,
      0.391376,
      1.567344,
      0.162709,
      NULL,
      NULL,
      1.722346,
      0.027162,
      0,
      1,
      1,
      2,
      3,
      1,
      0,
      4.483589,
      NULL,
      0,
      1,
      0.259513,
      0.552540,
      1,
      1.628988,
      8,
      NULL,
      NULL,
      0.407680,
      9,
      4,
      7,
      7,
      3.540044,
      2,
      5.099696,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.138008,
      1,
      1.892401,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.862653,
      NULL,
      3,
      1,
      3,
      1,
      NULL,
      NULL,
      3,
      3.368771,
      2,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.161053,
      5,
      2,
      0,
      0.401785,
      NULL,
      NULL,
      3,
      3,
      3.823818,
      3.464061,
      4,
      0.532802,
      NULL,
      0.651807,
      0,
      NULL,
      3.120553,
      NULL,
      1,
      3,
      3,
      NULL,
      3,
      0,
      1,
      0.115309,
      NULL,
      NULL,
      0,
      0,
      1,
      1.000169,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '10213',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


