set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502500';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-8-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '201',
      '14',
      20,
      0,
      '1014200',
      NULL,
      2,
      NULL,
      0,
      '441430',
      5,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      1,
      2.657623,
      NULL,
      NULL,
      1,
      NULL,
      2.452073,
      0,
      NULL,
      1.338825,
      2.408078,
      1,
      6,
      2,
      1.382349,
      1,
      9.034790,
      0,
      NULL,
      1.869458,
      1.745946,
      0.385412,
      NULL,
      NULL,
      2,
      1.454972,
      0.883096,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      1,
      NULL,
      0.954262,
      0.685200,
      0.063188,
      2.637751,
      NULL,
      1,
      1.951591,
      3.032245,
      NULL,
      0.885431,
      2.394816,
      2,
      1,
      1,
      1.598233,
      0,
      1,
      1,
      0.431894,
      1,
      0,
      2,
      0.833104,
      1.438064,
      NULL,
      NULL,
      0.942156,
      NULL,
      NULL,
      1,
      0.190528,
      0.081653,
      2,
      0,
      NULL,
      NULL,
      1,
      0.467740,
      NULL,
      1.192490,
      1,
      1.767211,
      NULL,
      0,
      1.699647,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.697738,
      0.850807,
      1.238808,
      NULL,
      2.779097,
      0,
      0,
      NULL,
      0.147509,
      NULL,
      0,
      0,
      NULL,
      1.167725,
      1.015906,
      0.019600,
      5,
      1,
      7.485112,
      7.812685,
      6,
      4,
      3,
      NULL,
      5,
      1.068431,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.412014,
      2,
      NULL,
      1,
      0.116177,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.734913,
      NULL,
      0.860419,
      0.743659,
      0,
      4.735047,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.979941,
      NULL,
      2,
      0.826207,
      2,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.596733,
      1.134598,
      NULL,
      NULL,
      0.717454,
      0,
      2.920129,
      NULL,
      1.010217,
      NULL,
      0,
      1,
      1.748435,
      1.598903,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.684288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.849748,
      '24144',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.670116,
      NULL,
      '',
      '',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


