set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6452968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      NULL,
      NULL,
      '4344400',
      1.884965,
      2,
      3,
      2,
      NULL,
      2,
      NULL,
      41.511877,
      NULL,
      0,
      NULL,
      1.059025,
      2.372703,
      0,
      0.814801,
      1,
      NULL,
      2,
      0.815596,
      1,
      1,
      2.839118,
      1,
      2,
      1.989211,
      0,
      1,
      0.246561,
      1,
      0,
      6.631712,
      1,
      1.697672,
      2.059929,
      1,
      NULL,
      1,
      2.631042,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.154518,
      NULL,
      0.022710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.346448,
      0,
      0.958422,
      2.547388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.845376,
      NULL,
      5,
      1.449344,
      3,
      1,
      5.417440,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      6,
      0,
      1.961537,
      NULL,
      0.007545,
      NULL,
      NULL,
      1.664951,
      NULL,
      NULL,
      0,
      1.749125,
      1,
      5,
      1,
      1.893708,
      0,
      NULL,
      NULL,
      1,
      1,
      0.824352,
      5,
      1,
      2.530367,
      0.736794,
      5,
      1,
      6.906775,
      0,
      NULL,
      1,
      0,
      1.336309,
      NULL,
      3.104717,
      1,
      1.252497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.402852,
      NULL,
      0,
      3,
      0.602159,
      0.547060,
      1.170530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.580343,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      1.494867,
      NULL,
      1,
      2.297324,
      1,
      0.675633,
      2.635584,
      3,
      0,
      4,
      1.253711,
      0,
      0,
      6.243409,
      0,
      0.709990,
      NULL,
      NULL,
      NULL,
      1.936276,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.097478,
      3,
      0,
      2.444137,
      0,
      3.327199,
      0.715581,
      0,
      1,
      0.633478,
      1.353227,
      1.147082,
      NULL,
      0.167073,
      1,
      0,
      NULL,
      1,
      1,
      1.823862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.992312,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.696452,
      0.592888,
      0.841772,
      NULL,
      1.380261,
      0,
      0.421901,
      1,
      NULL,
      '24410',
      '',
      '',
      1.839850,
      NULL,
      '',
      '',
      1.809268,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


