set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6452968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-12-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      NULL,
      NULL,
      '3413212',
      16,
      0,
      1.434250,
      3,
      '310434',
      1.635476,
      ' 9-11-1976',
      9.619584,
      NULL,
      0.422012,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1.748614,
      NULL,
      1,
      1,
      0.498203,
      0,
      0.638826,
      3,
      1.786570,
      1.582152,
      3.297894,
      2.822042,
      NULL,
      NULL,
      0.713160,
      0.143013,
      NULL,
      5,
      NULL,
      2.183633,
      4.197826,
      0.715044,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.729218,
      1,
      1.853859,
      0.451087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.481903,
      1.103738,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.631090,
      0,
      2.797627,
      1,
      NULL,
      1,
      NULL,
      1.493179,
      0.124795,
      3,
      3.791892,
      1.084104,
      0,
      1,
      1.783410,
      1,
      1.510842,
      0,
      NULL,
      NULL,
      0.849884,
      1.216638,
      0.182105,
      NULL,
      1.235973,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.211051,
      NULL,
      0,
      0.934392,
      0.277977,
      1.371491,
      6.445969,
      NULL,
      7,
      0,
      1,
      8.658615,
      1,
      3.231689,
      NULL,
      4.525402,
      1.875416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.146534,
      1,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.739424,
      NULL,
      1.823076,
      3,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.218087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      5.912484,
      2.541008,
      0.811989,
      1,
      3,
      0.636750,
      NULL,
      NULL,
      0.104412,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.750239,
      NULL,
      0.542691,
      1.103021,
      1.281075,
      1,
      NULL,
      1.291708,
      NULL,
      0.860383,
      0,
      0,
      NULL,
      0.254224,
      1.015382,
      1.276269,
      1,
      1.317611,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.657320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.323444,
      1.653217,
      NULL,
      NULL,
      0,
      1.554650,
      0.418965,
      0,
      0.956358,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.717847,
      NULL,
      NULL,
      NULL,
      NULL,
      0.686669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.448223,
      NULL,
      1.676751,
      NULL,
      NULL,
      1,
      NULL,
      '02143',
      '',
      NULL,
      0.494712,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


