set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6452968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-4-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      NULL,
      NULL,
      '1400123',
      4,
      5,
      NULL,
      2,
      '102132',
      3.489350,
      NULL,
      6.740779,
      NULL,
      1.936170,
      NULL,
      1.052512,
      0,
      2,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      0.583358,
      0,
      0.282566,
      0.773941,
      NULL,
      NULL,
      1.234226,
      NULL,
      0,
      1.113925,
      0.071227,
      0,
      1,
      1,
      0,
      NULL,
      2.446663,
      1,
      0.620459,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.643315,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.309116,
      1.502759,
      1,
      3.004798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.110902,
      NULL,
      1,
      1,
      4,
      1.858250,
      0,
      NULL,
      1,
      2,
      5,
      1,
      0,
      NULL,
      0,
      0,
      0.961148,
      NULL,
      0,
      NULL,
      0.702460,
      0,
      1.834409,
      0,
      0.116606,
      NULL,
      0,
      NULL,
      1.441539,
      0,
      NULL,
      0,
      0.729025,
      1,
      NULL,
      0.375289,
      NULL,
      3.237365,
      3.094287,
      3,
      7,
      1.161966,
      0.430271,
      NULL,
      5,
      4,
      NULL,
      5.493794,
      NULL,
      NULL,
      NULL,
      5.209738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.003161,
      NULL,
      1,
      NULL,
      0,
      1.843467,
      1.513673,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      2.207697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.165927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.272496,
      4,
      NULL,
      0.901327,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.096155,
      2.990693,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0.260485,
      1.850514,
      0.376833,
      0.766895,
      0,
      NULL,
      0.805774,
      1,
      0,
      0.184708,
      0,
      0,
      0.807214,
      0,
      0.295989,
      1.619281,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.801118,
      1.915795,
      0,
      NULL,
      0,
      0.414811,
      0.507826,
      0.430844,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.306806,
      NULL,
      NULL,
      NULL,
      NULL,
      2.767796,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.934524,
      1,
      3.027214,
      '13322',
      '',
      '',
      0.378374,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


