set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6452968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      NULL,
      NULL,
      '2431000',
      24.437010,
      3,
      2,
      NULL,
      '324402',
      NULL,
      ' 1-20-1987',
      31.822261,
      NULL,
      0,
      NULL,
      0.234893,
      NULL,
      3,
      NULL,
      3,
      0,
      NULL,
      1.361439,
      NULL,
      1,
      4.840634,
      NULL,
      7.754897,
      1.319479,
      NULL,
      1.912927,
      1.018359,
      2.332201,
      0,
      1,
      1,
      1.262128,
      7.374298,
      1,
      NULL,
      1,
      0.844771,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.783970,
      1.870316,
      1,
      1.611393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.254216,
      NULL,
      1.509581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      5.777356,
      NULL,
      1.142039,
      0.321205,
      0.696142,
      1.881046,
      2.247285,
      1,
      0.611255,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      0.906700,
      1,
      0,
      1.051615,
      0,
      NULL,
      0.915802,
      NULL,
      1.437552,
      1,
      NULL,
      1.917616,
      0,
      0.407116,
      NULL,
      0.933828,
      0.833651,
      2.991498,
      1,
      6.767826,
      4,
      0,
      3,
      5.021359,
      2.325054,
      1.553002,
      0.149632,
      1,
      0,
      1.570797,
      1.162013,
      3.968150,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.627982,
      NULL,
      1,
      1,
      7,
      0.060427,
      1.505740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      9,
      NULL,
      NULL,
      2.174999,
      0,
      3,
      1,
      NULL,
      NULL,
      1,
      0,
      2.775470,
      NULL,
      NULL,
      0,
      7,
      NULL,
      NULL,
      1.030256,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.809070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.460265,
      NULL,
      1.284200,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      1,
      1.335859,
      1,
      0.358780,
      1,
      0.587341,
      1.119565,
      1.371073,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.689470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.644753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.530464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.241506,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.626328,
      NULL,
      0.898112,
      1.743328,
      1,
      0,
      NULL,
      '10103',
      '',
      '',
      0.349780,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


