set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6452968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      NULL,
      NULL,
      '3041323',
      NULL,
      NULL,
      3.085358,
      3,
      '304343',
      2.870049,
      ' 7- 7-1979',
      27.885907,
      NULL,
      0.035577,
      NULL,
      3,
      1.241627,
      2,
      1.301374,
      1.472997,
      1,
      0.097604,
      0,
      NULL,
      1.067526,
      5.028412,
      1.698747,
      0.871940,
      1.950351,
      NULL,
      0.391717,
      NULL,
      0.730154,
      0.487013,
      1.111757,
      0.135006,
      1,
      4.823091,
      NULL,
      0,
      1,
      NULL,
      1.636502,
      NULL,
      NULL,
      0.856407,
      NULL,
      NULL,
      1.671237,
      2.998947,
      2,
      1.834921,
      1,
      0.301936,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      0.124558,
      2.159751,
      NULL,
      3.173089,
      0.729202,
      NULL,
      1.461017,
      NULL,
      1.026332,
      0,
      2.228508,
      0,
      1,
      1.899681,
      0.157247,
      NULL,
      NULL,
      1.341656,
      NULL,
      NULL,
      1.057388,
      NULL,
      0.140165,
      1,
      1,
      1,
      1.919857,
      0.099364,
      0.094706,
      NULL,
      1.509074,
      NULL,
      0,
      0,
      0.121084,
      1,
      1.405865,
      0.484402,
      1,
      NULL,
      NULL,
      1.261287,
      NULL,
      1,
      1,
      0,
      NULL,
      0.902545,
      NULL,
      NULL,
      0,
      NULL,
      0.375443,
      1,
      0,
      1.471482,
      0.564031,
      3.866626,
      2,
      0.493308,
      NULL,
      0,
      NULL,
      6.218484,
      4,
      NULL,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.011915,
      1,
      2,
      1,
      1,
      NULL,
      1.641198,
      0.173106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.073492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.257292,
      5.260057,
      NULL,
      2,
      2.005361,
      0,
      NULL,
      NULL,
      0,
      0.521048,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.474923,
      NULL,
      0.885432,
      0.553653,
      0.836222,
      NULL,
      0,
      1,
      0.488846,
      0.802375,
      0,
      1.240441,
      1.002701,
      0,
      0,
      1,
      0,
      0.319384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '20013',
      NULL,
      '',
      1.661717,
      NULL,
      NULL,
      '',
      1.221154,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


