set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6452968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-5-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      NULL,
      '4241242',
      NULL,
      6,
      NULL,
      2,
      '201411',
      2,
      '11- 5-1975',
      49.351712,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1.850517,
      3.996041,
      NULL,
      1.350750,
      1.674275,
      NULL,
      NULL,
      NULL,
      NULL,
      1.620836,
      0,
      1.990584,
      0,
      3.400668,
      3.100376,
      2,
      4.256352,
      1,
      0.691135,
      NULL,
      NULL,
      1.898779,
      1.943034,
      NULL,
      1.887265,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.929379,
      0.804510,
      1.322478,
      1.897154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.328476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.254029,
      NULL,
      0,
      0,
      0.542832,
      0.046295,
      1,
      0,
      1,
      0,
      0.876189,
      0.851669,
      0.818140,
      1.971941,
      0.934188,
      1.306469,
      0.917719,
      NULL,
      0,
      0,
      1.095282,
      1,
      NULL,
      1.744201,
      1,
      0,
      1,
      NULL,
      0.553400,
      1.350364,
      0.445082,
      NULL,
      NULL,
      0.394389,
      2,
      2,
      2,
      0.761239,
      1.022385,
      2.924120,
      4.303878,
      3,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.401486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.164613,
      1,
      1,
      NULL,
      0.349240,
      1.866413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.924386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.478319,
      1,
      1.332233,
      1.440977,
      3,
      0,
      5,
      1,
      NULL,
      1.246814,
      0,
      2,
      1,
      1.244948,
      NULL,
      NULL,
      1.779011,
      1.911138,
      1.771212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.194985,
      NULL,
      0.276967,
      1.438428,
      1,
      0,
      0.458519,
      1,
      0,
      1,
      0,
      1,
      0,
      0.172968,
      NULL,
      0.641471,
      1.245051,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


