set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9851628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '202',
      '34342323',
      8.793012,
      46.376170,
      '2311203',
      1.132782,
      NULL,
      0,
      3,
      NULL,
      0.062080,
      ' 1-10-1992',
      160,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      2,
      1,
      NULL,
      0,
      1.933278,
      3.073772,
      NULL,
      1.310810,
      2.835206,
      6,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0.163671,
      NULL,
      NULL,
      1,
      2.011579,
      0,
      1.854205,
      NULL,
      NULL,
      1.013971,
      NULL,
      NULL,
      0.729667,
      1,
      1,
      1.220821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.007963,
      0,
      2,
      3.476210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.043322,
      0,
      1,
      0.728948,
      0,
      NULL,
      0.797481,
      0.176397,
      NULL,
      0.272926,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.731969,
      3,
      1.920944,
      0,
      1.079840,
      NULL,
      NULL,
      0,
      NULL,
      0.844804,
      1.153750,
      0,
      NULL,
      0.161118,
      1.675184,
      NULL,
      1.076258,
      5,
      7,
      3,
      NULL,
      5.282422,
      NULL,
      5,
      NULL,
      1,
      1,
      0,
      2,
      0.036774,
      0.602661,
      9.996045,
      1.213334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.460397,
      0,
      0,
      1,
      1.397738,
      NULL,
      0.948963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.513227,
      1.098555,
      3,
      0.561644,
      1.352071,
      0.850209,
      1,
      0.230682,
      0,
      NULL,
      NULL,
      NULL,
      1.402875,
      3,
      0,
      1,
      1.873076,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.980409,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1,
      0,
      0.808452,
      0,
      0,
      1,
      0,
      NULL,
      0,
      0.672775,
      0.862675,
      NULL,
      NULL,
      0.051692,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '14221',
      '',
      '',
      1.251582,
      '',
      '',
      NULL,
      0.189353,
      '',
      '',
      '',
      3,
      3.023611,
      NULL,
      5.425379,
      1,
      3.120281,
      0,
      2,
      2);
commit;
end;
/


