set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3374023';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1331',
      '33141220',
      6.670217,
      88,
      '1134330',
      10.489628,
      1,
      2,
      NULL,
      '214430',
      NULL,
      NULL,
      27.223480,
      37,
      1,
      NULL,
      3.376998,
      3.703308,
      NULL,
      1.409922,
      0,
      2,
      NULL,
      1,
      1,
      0.848774,
      0.492659,
      0,
      NULL,
      1,
      1.961435,
      0,
      3.758240,
      NULL,
      1,
      0,
      1.147268,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.922934,
      0,
      NULL,
      NULL,
      0.206343,
      3.167321,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1.877438,
      0.384245,
      3.271340,
      0.721748,
      NULL,
      NULL,
      NULL,
      1.158162,
      2.603892,
      1,
      0,
      0.981070,
      0.254645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.373700,
      1,
      1.072747,
      NULL,
      0,
      0.404008,
      0.663035,
      1,
      NULL,
      NULL,
      0.582822,
      0.909809,
      1,
      0.983258,
      NULL,
      NULL,
      NULL,
      1.849915,
      NULL,
      1,
      1.952597,
      1,
      1,
      1.813695,
      1.549933,
      0.429786,
      0.695538,
      NULL,
      1,
      1.117899,
      1.233067,
      NULL,
      1,
      1,
      0,
      0.100182,
      3.129149,
      NULL,
      3.404196,
      3.049501,
      NULL,
      3,
      NULL,
      0,
      0.029434,
      NULL,
      0,
      1.392892,
      NULL,
      NULL,
      6.847185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.339860,
      0,
      NULL,
      0,
      1,
      1.006773,
      1.689587,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.183076,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.490589,
      0.083500,
      0,
      0.999277,
      NULL,
      NULL,
      NULL,
      0,
      1.634460,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.523508,
      3.200371,
      NULL,
      3.992368,
      1.427221,
      1,
      0,
      0.450644,
      0,
      1.505456,
      0.818384,
      1.832970,
      0.342198,
      0,
      0,
      1,
      1,
      NULL,
      0,
      1.994332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.751833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      NULL,
      '14041',
      '23134',
      0.738424,
      '',
      NULL,
      '',
      0.882132,
      '',
      '',
      NULL,
      5.646648,
      1.275089,
      1.509307,
      NULL,
      0,
      3,
      0,
      NULL,
      1.160862);
commit;
end;
/


