set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9512010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '230',
      '20',
      17.982911,
      NULL,
      '0202141',
      2,
      6,
      2.666161,
      0,
      '003420',
      0.532471,
      ' 8- 1-1989',
      38,
      25.007612,
      1.706050,
      NULL,
      0,
      3,
      1.916566,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.171904,
      0,
      0.463569,
      0.479893,
      0.395637,
      3,
      1,
      0,
      1.408950,
      NULL,
      1.207663,
      4.304275,
      NULL,
      4,
      0.668563,
      1,
      1,
      NULL,
      NULL,
      1.470527,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      2,
      2.841478,
      1.261683,
      1.333138,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      4,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      1.520878,
      NULL,
      NULL,
      NULL,
      1,
      1.031544,
      1.654447,
      0,
      0.350323,
      0.650477,
      1.998598,
      0.019979,
      0,
      NULL,
      NULL,
      0.707584,
      0,
      NULL,
      0,
      0,
      NULL,
      0.404538,
      NULL,
      NULL,
      0.731493,
      1.957370,
      1.491725,
      0,
      1,
      0.281833,
      0.394295,
      2.767174,
      1,
      1.852160,
      0.490689,
      NULL,
      1.267146,
      0,
      1.189850,
      1.606958,
      1,
      3.206730,
      0,
      NULL,
      3,
      2,
      0.277580,
      3.092648,
      1,
      0,
      0.707243,
      3,
      1,
      NULL,
      5.774973,
      0.482356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.574060,
      0,
      1,
      0.621210,
      0.101033,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.561745,
      1.659350,
      3,
      3,
      0,
      0.104005,
      NULL,
      NULL,
      4.203294,
      3.979701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.563966,
      7,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.568658,
      9.124201,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.602908,
      1,
      1.988853,
      0.592483,
      NULL,
      1,
      1.727139,
      NULL,
      0.242920,
      0.580870,
      1,
      0,
      0,
      0,
      1,
      3.617409,
      NULL,
      0,
      0,
      1.093199,
      2.667578,
      0,
      NULL,
      0.770931,
      1,
      1.475304,
      0.714345,
      1,
      NULL,
      1.502826,
      0.707209,
      NULL,
      NULL,
      0.109367,
      0.820945,
      1,
      1.596016,
      1,
      NULL,
      0.767045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.937122,
      1.863723,
      0,
      NULL,
      0.706567,
      0.531818,
      1,
      1.144842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.472249,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '11330',
      '42421',
      '',
      1.080236,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


