set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9512010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '043',
      '10',
      30,
      13.848746,
      '0212124',
      9,
      4,
      3,
      NULL,
      '342113',
      NULL,
      ' 6-21-2000',
      10.115208,
      20,
      1.489685,
      NULL,
      3.702664,
      NULL,
      0,
      0.698430,
      0.064981,
      3.930230,
      NULL,
      1,
      1.198780,
      1.804958,
      NULL,
      0,
      1,
      2.187614,
      1.067975,
      1.769486,
      4,
      0.358557,
      9,
      6.785793,
      5.765808,
      5.535086,
      7,
      NULL,
      2.562376,
      NULL,
      3.623209,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.554430,
      3.140630,
      NULL,
      1.461421,
      NULL,
      NULL,
      1,
      2.215945,
      3.467294,
      2.638993,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      1.315005,
      4.115073,
      4,
      6.217294,
      1,
      NULL,
      0.685934,
      1.893882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.836167,
      0,
      1.974099,
      0.570053,
      1.224819,
      0,
      NULL,
      0.106947,
      NULL,
      0,
      0.286489,
      1,
      1,
      1.423663,
      1,
      0,
      0.423622,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0.804528,
      1.981221,
      1,
      NULL,
      0.219734,
      1,
      1.419538,
      1,
      NULL,
      2.514255,
      0,
      0.833317,
      1.243926,
      0.477310,
      4,
      NULL,
      0.546529,
      4.510424,
      5.531536,
      3.567564,
      NULL,
      2.071317,
      1.868050,
      3.466255,
      0.434360,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.462898,
      0.870949,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.990452,
      2.651973,
      NULL,
      1.706086,
      5.024126,
      8,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.970883,
      0.371001,
      NULL,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.076326,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.226535,
      1,
      0.274747,
      3.707222,
      0,
      NULL,
      0,
      0,
      1.494836,
      1,
      0,
      1,
      1.916016,
      NULL,
      0,
      1,
      NULL,
      0.497633,
      NULL,
      NULL,
      0.949115,
      0,
      3.023100,
      1.560992,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0.979941,
      1.239840,
      0.178396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.560449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.292565,
      0,
      NULL,
      8.319992,
      3,
      0,
      NULL,
      1,
      0.997706,
      3.507569,
      0,
      NULL,
      1,
      1.820949,
      0.219741,
      0.643358,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.507277,
      NULL,
      '44031',
      NULL,
      0,
      '',
      '',
      '',
      0.846479,
      NULL,
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


