set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9512010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '303',
      '41',
      NULL,
      NULL,
      '1133034',
      4.822154,
      2,
      3,
      2,
      '314011',
      2,
      ' 3-25-1989',
      NULL,
      14.517450,
      1.854455,
      NULL,
      1.390466,
      3.844524,
      1.452131,
      0.988374,
      NULL,
      0.705080,
      3,
      0,
      0,
      1,
      NULL,
      0.773685,
      0,
      NULL,
      0.799130,
      0,
      1.159508,
      1,
      10,
      8.530981,
      9.805013,
      2.713518,
      2.275146,
      1,
      NULL,
      1.406208,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.107326,
      1,
      1.320300,
      NULL,
      0,
      0.980643,
      NULL,
      NULL,
      1,
      1,
      0.635352,
      0.785240,
      0.748240,
      NULL,
      3,
      NULL,
      NULL,
      1.820331,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.169349,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.562453,
      0.334975,
      0,
      0,
      0,
      0,
      1,
      NULL,
      1.093142,
      0.960584,
      1.348892,
      NULL,
      NULL,
      0.917725,
      1.166670,
      0,
      NULL,
      1,
      1,
      NULL,
      1.024148,
      1,
      0,
      0,
      1.854017,
      0.151472,
      0.604398,
      0,
      1.273930,
      0.440956,
      NULL,
      1.140765,
      0,
      1.985309,
      NULL,
      1.923144,
      1,
      NULL,
      3,
      NULL,
      0.792705,
      NULL,
      0,
      NULL,
      1.467720,
      NULL,
      2,
      2,
      0.858220,
      1.091507,
      1.516946,
      3.286590,
      1.482425,
      2,
      NULL,
      2.858104,
      1.923426,
      1.527742,
      0.316289,
      1.102179,
      1,
      0,
      0.065537,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.200943,
      NULL,
      NULL,
      NULL,
      NULL,
      4.307343,
      1.447403,
      1.923903,
      NULL,
      0,
      0,
      2.619513,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.280606,
      5,
      1,
      4.258733,
      0,
      1.501502,
      NULL,
      NULL,
      NULL,
      1.130513,
      NULL,
      1.969232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.388790,
      2,
      2,
      0,
      1,
      0.287537,
      1,
      1.797936,
      0,
      2,
      0.014281,
      1,
      0.347091,
      1.786877,
      1,
      NULL,
      0.531588,
      1.659523,
      1.713853,
      1,
      1.401772,
      1.066885,
      1.702180,
      1,
      NULL,
      NULL,
      3.613862,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.910016,
      1,
      1.977200,
      1.954103,
      0.049246,
      0.938501,
      NULL,
      0.236879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.485088,
      NULL,
      '01401',
      '',
      NULL,
      '',
      '',
      '',
      0.399854,
      '',
      '',
      '',
      1.617043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


