set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9512010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-6-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '412',
      '23',
      NULL,
      13,
      '3222340',
      22,
      NULL,
      3,
      3,
      '241201',
      3.733614,
      ' 3- 5-2003',
      14.186614,
      60.499220,
      0,
      NULL,
      NULL,
      0,
      1,
      1.187644,
      0.726114,
      0.218977,
      1,
      1,
      1.426684,
      NULL,
      NULL,
      1.318897,
      NULL,
      2,
      0.549358,
      0,
      5,
      1.832210,
      NULL,
      0,
      2,
      1.230566,
      4,
      1,
      3.884880,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.978655,
      1,
      1.152109,
      0.926649,
      0.390386,
      3.846762,
      2.538030,
      3.894357,
      NULL,
      NULL,
      3.895555,
      0,
      0,
      1.938828,
      1,
      0.192835,
      NULL,
      1,
      3,
      1.661664,
      4,
      3,
      4,
      0,
      0,
      4,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.403409,
      0.459191,
      1.840396,
      NULL,
      NULL,
      1.104030,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      1,
      0.392065,
      1.856526,
      1.256258,
      NULL,
      0.989023,
      NULL,
      1.999785,
      NULL,
      0.072657,
      1,
      0,
      0.913489,
      0,
      1.673307,
      0.605348,
      1,
      NULL,
      1,
      1.192902,
      1,
      0.421638,
      1.068947,
      1.206016,
      1.628395,
      1,
      3,
      2.274451,
      5,
      0,
      0,
      1,
      1,
      0,
      1.787897,
      0,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.517008,
      NULL,
      1,
      NULL,
      1.270831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.282332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.278404,
      1.943051,
      1.441497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.222372,
      2.720592,
      2,
      1.836752,
      NULL,
      NULL,
      NULL,
      NULL,
      3.797352,
      1.640186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.104194,
      0.856862,
      NULL,
      0,
      0,
      0.394666,
      0.931811,
      1.072567,
      NULL,
      NULL,
      0.756226,
      1.236955,
      0,
      1.862747,
      1.967450,
      NULL,
      2.247075,
      1.933073,
      1,
      NULL,
      1,
      2,
      2.363491,
      3,
      0.332809,
      0,
      1,
      NULL,
      1.034034,
      1,
      0,
      0,
      NULL,
      0,
      0.171250,
      0.848655,
      NULL,
      1.241470,
      0.376253,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '32123',
      '10034',
      '',
      1,
      NULL,
      '',
      '',
      1.308966,
      NULL,
      '',
      '',
      1.963169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


