set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9512010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-10-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '212',
      '13',
      20,
      9.927860,
      '2110304',
      NULL,
      2,
      1.706995,
      NULL,
      '444220',
      4.301438,
      ' 3-11-1996',
      48.064607,
      36,
      1.501183,
      NULL,
      0.055380,
      1.082769,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      1.951879,
      0.798243,
      4.229066,
      1.790202,
      0.044964,
      5,
      1,
      0.590722,
      7,
      0,
      10.602876,
      9.771556,
      5.558062,
      1.502552,
      1,
      1,
      2,
      0.091588,
      0.683509,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.488149,
      1,
      1,
      2,
      NULL,
      3,
      3,
      NULL,
      1,
      NULL,
      0.635512,
      1,
      3.933548,
      1,
      0,
      1.784635,
      0.136787,
      1,
      NULL,
      1,
      1,
      2.848441,
      6.888284,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.383205,
      NULL,
      1.513875,
      NULL,
      1,
      0.038183,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.874402,
      0.649313,
      NULL,
      0,
      NULL,
      1,
      0,
      1.604518,
      NULL,
      0,
      1.249908,
      0,
      0.017185,
      0.607640,
      1.038405,
      0.172485,
      NULL,
      0,
      1,
      0,
      1.501272,
      1.837193,
      1,
      2,
      1,
      1,
      0.920441,
      NULL,
      0,
      0.961484,
      3.476697,
      0.958175,
      1,
      2,
      NULL,
      0.148005,
      NULL,
      3.359324,
      0.217906,
      0,
      2.704846,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1.265139,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.478130,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.083641,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      9,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.093254,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.248395,
      1.042258,
      3,
      2.715274,
      1.840667,
      NULL,
      0,
      0,
      1.547746,
      NULL,
      3,
      1,
      1,
      1.555045,
      0,
      0,
      1,
      0,
      0,
      2,
      1.792581,
      1.067763,
      1,
      2.049601,
      NULL,
      NULL,
      2,
      1,
      0,
      1.616259,
      0,
      0,
      0,
      0,
      1.949131,
      1.693677,
      1.539983,
      0.893987,
      0,
      NULL,
      1.302748,
      1,
      1.776846,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.412275,
      NULL,
      '14032',
      NULL,
      1,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


