set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9512010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '32402004',
      40.448484,
      12,
      '0444111',
      25.152225,
      0,
      NULL,
      1,
      '032241',
      3,
      ' 1-25-1997',
      53,
      10.059670,
      NULL,
      NULL,
      1.701903,
      NULL,
      1.661054,
      1.495800,
      NULL,
      0,
      3,
      0,
      0,
      NULL,
      7,
      1.657122,
      1,
      NULL,
      1,
      4,
      6.799918,
      1.787139,
      1.116446,
      2,
      NULL,
      1,
      5,
      NULL,
      5.350633,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.825288,
      NULL,
      NULL,
      5,
      0,
      NULL,
      1.007670,
      1,
      1,
      NULL,
      1,
      3,
      2.333953,
      NULL,
      3,
      1,
      3,
      1,
      1,
      0,
      1,
      1.514029,
      NULL,
      0,
      6.008506,
      6,
      1,
      1,
      NULL,
      0.828211,
      NULL,
      NULL,
      1.256002,
      NULL,
      NULL,
      NULL,
      0.942691,
      0,
      0.066336,
      4.549547,
      NULL,
      1,
      1.524503,
      1.509457,
      1,
      0,
      NULL,
      0.830260,
      0.667672,
      0,
      NULL,
      0,
      0.594001,
      0,
      NULL,
      1,
      1,
      0.009400,
      0.417382,
      5.230114,
      1,
      NULL,
      0,
      0,
      5,
      5.382859,
      0,
      NULL,
      1,
      5.791106,
      1,
      7.978955,
      NULL,
      3,
      0,
      4.121985,
      3.439851,
      2,
      5,
      5,
      7.295815,
      NULL,
      5.261023,
      1.613757,
      0.764345,
      1,
      3.331008,
      0.583219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.326415,
      NULL,
      0,
      NULL,
      1,
      1.021740,
      2,
      0.592100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.597893,
      NULL,
      0.497079,
      0,
      0.910247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.544074,
      2,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      4.506358,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.450736,
      1,
      2.499249,
      0.419164,
      0.289021,
      NULL,
      NULL,
      0,
      0.773080,
      NULL,
      0.250976,
      NULL,
      1.006618,
      1.311651,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.084121,
      '11304',
      '22044',
      '',
      0.689407,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      3,
      NULL,
      0,
      2.825533,
      2.268843,
      1.027728,
      2.666649,
      4,
      3);
commit;
end;
/


