set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9512010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '111',
      NULL,
      30,
      43.906322,
      '4010341',
      67.569604,
      1,
      0.540939,
      3,
      '004040',
      0,
      ' 3-28-1988',
      52.135887,
      5,
      0,
      NULL,
      0,
      0.638595,
      2.592425,
      0.273743,
      0,
      NULL,
      1.394496,
      1.838195,
      0.757850,
      1,
      4,
      NULL,
      0.953228,
      4,
      1.982566,
      1,
      1,
      1.859477,
      NULL,
      NULL,
      3,
      9.662077,
      5.808994,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.905048,
      NULL,
      4.707288,
      3,
      0.881064,
      0,
      NULL,
      2.226339,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.541031,
      0,
      2,
      0.249362,
      2.614823,
      1.265346,
      0,
      NULL,
      5,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.004803,
      1.782767,
      0,
      1,
      4.577444,
      1,
      0.436052,
      0.041895,
      1,
      0.505499,
      1.936249,
      1.846202,
      NULL,
      1.756849,
      1,
      0,
      1.526986,
      0.072712,
      1.926436,
      NULL,
      0,
      NULL,
      1.783441,
      0.285500,
      NULL,
      NULL,
      0.809574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.049605,
      0,
      NULL,
      0,
      1,
      7,
      NULL,
      2,
      2.341875,
      2,
      3,
      3,
      2.314764,
      0.942569,
      1.456430,
      0,
      3,
      0.467930,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.229400,
      0,
      0,
      1.916599,
      NULL,
      1.429069,
      0.528750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      1.557338,
      1.120387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.180359,
      0,
      1,
      2.437958,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      6.067147,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.065512,
      0.461778,
      0,
      1.746382,
      0,
      0.370166,
      1.623999,
      NULL,
      2,
      NULL,
      1.344389,
      1.562663,
      0,
      1.157008,
      0.437343,
      0.031630,
      0,
      0.700999,
      0.624042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.734422,
      0,
      0.933500,
      NULL,
      1,
      1,
      0.533714,
      0,
      0.801914,
      0,
      0.621606,
      NULL,
      1.895230,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.581889,
      NULL,
      NULL,
      NULL,
      NULL,
      0.049387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      '22122',
      '',
      0,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL,
      5,
      1.072845,
      2,
      1,
      0,
      2.358768,
      3.782078,
      6.055619,
      3.239230);
commit;
end;
/


