set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9512010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43024043',
      20.381862,
      44,
      NULL,
      48,
      6,
      NULL,
      1,
      '112341',
      2,
      '10-23-1984',
      38,
      57,
      0.511119,
      NULL,
      1,
      0.118040,
      NULL,
      0.885613,
      1,
      0.199497,
      0.642679,
      1,
      1.935539,
      NULL,
      3.291320,
      NULL,
      1.832416,
      1.670658,
      0,
      1.752809,
      NULL,
      NULL,
      1,
      0.065526,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.655132,
      1.525638,
      0,
      1.171547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.055910,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4.859786,
      0,
      NULL,
      1,
      3,
      3,
      1.182218,
      NULL,
      NULL,
      0.594498,
      0,
      1.801623,
      1,
      NULL,
      0,
      1.917576,
      0,
      1.144321,
      NULL,
      1,
      NULL,
      1,
      0,
      5.842120,
      1,
      5.310038,
      NULL,
      2,
      1,
      0.865314,
      NULL,
      0.716511,
      1,
      NULL,
      1.676248,
      2.360478,
      NULL,
      0,
      7.464718,
      1.114904,
      0.498458,
      NULL,
      NULL,
      3.638214,
      1.689599,
      11.062121,
      4.447723,
      0.062269,
      NULL,
      NULL,
      5.236822,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.569401,
      1.094846,
      0,
      1,
      0,
      0,
      4,
      1.861541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.372542,
      NULL,
      NULL,
      NULL,
      NULL,
      0.239337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.560358,
      1.666798,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.046328,
      3.970998,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.994648,
      1.115620,
      NULL,
      1.768233,
      NULL,
      3.789777,
      1.601112,
      2.254257,
      0,
      3,
      1,
      0.485437,
      1,
      1,
      1,
      0,
      1.798193,
      0.547527,
      0.204267,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.573772,
      1,
      1,
      NULL,
      0,
      0.549257,
      NULL,
      1.125870,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      8,
      0,
      NULL,
      0,
      0.879282,
      0.212846,
      1.910315,
      2.701705,
      0,
      1.084261,
      1.006720,
      0.671578,
      0.337767,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.857603,
      NULL,
      NULL,
      0,
      3.427486,
      2.885803,
      2,
      1.066210,
      0,
      NULL,
      0,
      5,
      NULL,
      '03324',
      '',
      NULL,
      '',
      NULL,
      NULL,
      0,
      '',
      NULL,
      '',
      3,
      5,
      4.352657,
      3.890547,
      NULL,
      3.227172,
      1,
      NULL,
      5);
commit;
end;
/


