set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9512010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '223',
      '11013140',
      NULL,
      53.859537,
      '4300030',
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      ' 6- 9-1997',
      45,
      24,
      0,
      NULL,
      1,
      1.646824,
      3,
      NULL,
      0.674194,
      NULL,
      1.261812,
      0.391751,
      1.193093,
      0.073740,
      4,
      1.411259,
      1.657351,
      NULL,
      1,
      NULL,
      0,
      2,
      0.114815,
      5.658461,
      5,
      0.947806,
      2.708987,
      1,
      1,
      NULL,
      1.940290,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.024445,
      0.637813,
      0.979168,
      2.540072,
      1.234470,
      0.807243,
      3.066568,
      0,
      2.941889,
      1.083067,
      0,
      1,
      1,
      0,
      0.831707,
      0,
      3,
      NULL,
      1.936385,
      NULL,
      NULL,
      7,
      6,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.698963,
      3.056636,
      0.656987,
      2.776401,
      1.932453,
      0,
      1,
      0,
      0,
      1.074021,
      0,
      0.892532,
      1,
      1.819923,
      NULL,
      1.671554,
      0.340476,
      1.134044,
      NULL,
      1.916566,
      0.724807,
      1.249665,
      0.307772,
      1.581667,
      1.216638,
      0.670844,
      1,
      3,
      0,
      1,
      0.019029,
      1.806274,
      0.662899,
      1.759945,
      NULL,
      NULL,
      3.176421,
      3,
      0.919394,
      NULL,
      5,
      NULL,
      NULL,
      5.092433,
      NULL,
      0,
      0.540028,
      0,
      0,
      NULL,
      9,
      0.427489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0.237869,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.098236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.008688,
      NULL,
      NULL,
      NULL,
      NULL,
      2.436033,
      0,
      2.072486,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.895795,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.425765,
      2,
      0.302651,
      1.163858,
      2.917335,
      0.399342,
      3,
      NULL,
      0.890556,
      2,
      1,
      NULL,
      1.357446,
      NULL,
      0.924200,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '31130',
      '24242',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      0.535198,
      NULL,
      0,
      1.927605,
      2.218793,
      NULL,
      0,
      0.392548);
commit;
end;
/


