set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9512010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '20214030',
      34,
      46.349418,
      '3422223',
      65.536445,
      3,
      0,
      NULL,
      '044222',
      3.509661,
      ' 1-25-1979',
      27.859994,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.301777,
      0.377890,
      2.826115,
      0,
      1.786507,
      0.821172,
      1.164065,
      2,
      NULL,
      1,
      1.321685,
      1.103395,
      1.335383,
      3.704817,
      4.157321,
      9.855551,
      0.833346,
      1.558818,
      NULL,
      2.097825,
      1,
      2,
      NULL,
      3.900410,
      0,
      NULL,
      NULL,
      1.033465,
      NULL,
      NULL,
      3,
      1.723063,
      0.676339,
      1,
      0,
      0,
      3,
      3.265872,
      0,
      NULL,
      2.281928,
      3,
      1.767873,
      2,
      NULL,
      1,
      3,
      0.406212,
      1.861073,
      0.140086,
      0.378144,
      5,
      1.270058,
      NULL,
      0,
      NULL,
      1.688486,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.002680,
      3,
      0,
      NULL,
      4,
      NULL,
      1.308227,
      0,
      0,
      NULL,
      0.618208,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      1.719695,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.844255,
      1,
      NULL,
      1.044521,
      1,
      0,
      1.383443,
      NULL,
      1,
      1,
      0.616896,
      0,
      0,
      NULL,
      NULL,
      0,
      7.996280,
      2.310164,
      7.199064,
      5.975988,
      5.948621,
      2,
      2.426301,
      0.994844,
      1.990060,
      0,
      0.424143,
      0.409064,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.264620,
      1,
      1,
      1.965707,
      1.506748,
      0.998348,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.443231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.785598,
      NULL,
      NULL,
      NULL,
      0,
      1.921067,
      0.485083,
      1,
      3.365125,
      0,
      0.337317,
      NULL,
      NULL,
      NULL,
      1.014183,
      5.712027,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.751187,
      NULL,
      1.108174,
      NULL,
      1,
      3.537151,
      NULL,
      0.122711,
      1.350147,
      0,
      0.627667,
      1.148203,
      1.062238,
      1.553017,
      0,
      0,
      0.118794,
      1.488585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '24214',
      '11134',
      '',
      1.638539,
      NULL,
      '',
      NULL,
      0.423970,
      NULL,
      '',
      '',
      0.279161,
      2,
      2,
      2.865779,
      0.706463,
      5.875244,
      NULL,
      3,
      2);
commit;
end;
/


