set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9512010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2300',
      '01303411',
      68.829688,
      26.931471,
      '1101320',
      NULL,
      4,
      3,
      2,
      '103120',
      1.322010,
      ' 9-23-1975',
      8,
      39,
      0.352659,
      NULL,
      2.653537,
      NULL,
      0,
      1,
      1.672612,
      0,
      NULL,
      1.826364,
      0.163743,
      1.619658,
      NULL,
      0,
      0,
      3.285800,
      NULL,
      2.988136,
      NULL,
      0.546355,
      5,
      0.579842,
      NULL,
      NULL,
      2,
      0,
      5.959401,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.240644,
      NULL,
      0,
      1,
      NULL,
      1.047283,
      1,
      2.369843,
      3,
      0.135519,
      1.122701,
      0,
      0.839165,
      1.799956,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.131826,
      0.653746,
      NULL,
      1,
      0,
      2,
      0.606597,
      1.576670,
      NULL,
      NULL,
      1.847790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.846604,
      1,
      0,
      1,
      1.716918,
      0.205750,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.854711,
      1.412887,
      NULL,
      0,
      NULL,
      0.559875,
      NULL,
      NULL,
      0.139051,
      NULL,
      NULL,
      2.474188,
      NULL,
      1,
      5.791397,
      0.152970,
      0.435464,
      1.317067,
      0,
      1,
      0,
      1.318313,
      1.086346,
      4.349704,
      2,
      4,
      11,
      5,
      0,
      7.452589,
      NULL,
      0,
      7.452590,
      0,
      0,
      0,
      3,
      1.898906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.219472,
      0,
      NULL,
      1,
      0.524301,
      0,
      0.028943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.498056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.778448,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.651354,
      7,
      3,
      1.993651,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      1,
      2.908028,
      2.673638,
      2.407150,
      0.409410,
      3,
      NULL,
      1.873150,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      1.278836,
      0.542823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.805608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.267695,
      '00342',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0.473214,
      '',
      NULL,
      NULL,
      4,
      NULL,
      0.255286,
      2,
      1,
      5,
      3.192387,
      1,
      0);
commit;
end;
/


