set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9512010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2121',
      '04204120',
      59.060028,
      48.641923,
      '4320414',
      172.849195,
      5,
      0,
      NULL,
      '314124',
      3.096241,
      ' 0-14-1986',
      32.933843,
      63.712894,
      NULL,
      NULL,
      1,
      0.091419,
      3.871431,
      0,
      1,
      3,
      NULL,
      0.778077,
      1,
      0,
      0.937493,
      NULL,
      0,
      1,
      NULL,
      1.114148,
      0.882932,
      1,
      3.420622,
      3,
      NULL,
      NULL,
      2.537529,
      0,
      4.600235,
      1,
      0.157951,
      0.987138,
      NULL,
      NULL,
      1.536270,
      NULL,
      NULL,
      2.687809,
      0,
      0,
      0,
      NULL,
      NULL,
      3.955740,
      2.901413,
      1.161941,
      1,
      NULL,
      3,
      NULL,
      1,
      0,
      0,
      2,
      1,
      NULL,
      1.262428,
      0.709065,
      0,
      7.244659,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.332431,
      NULL,
      NULL,
      NULL,
      0.637311,
      NULL,
      0,
      5.982518,
      1,
      1.279575,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1.298812,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      1.297906,
      1.023005,
      0.133879,
      1,
      0,
      1,
      2,
      1,
      4.474589,
      1,
      1,
      3.476033,
      4,
      0,
      8,
      NULL,
      NULL,
      NULL,
      2.964408,
      5,
      NULL,
      NULL,
      NULL,
      5,
      3,
      1.095513,
      0,
      1,
      1.536707,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.155533,
      1,
      0,
      NULL,
      1.688634,
      1.035759,
      1.179145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.423855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.646047,
      0,
      0.215077,
      4.510756,
      0.966791,
      0,
      1.849018,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.330922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.217470,
      1.347596,
      NULL,
      0.331646,
      1,
      1.886097,
      1.619519,
      2.710139,
      1.591502,
      0.494862,
      1.413742,
      1.336582,
      NULL,
      0,
      0,
      0,
      0.234845,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '30203',
      '42331',
      '',
      1,
      '',
      NULL,
      '',
      0,
      '1003',
      '',
      '',
      0.970373,
      NULL,
      0,
      1.149992,
      1,
      NULL,
      1,
      1.725805,
      3.311865);
commit;
end;
/


