set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9512010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4014',
      '22032000',
      NULL,
      19.491275,
      NULL,
      NULL,
      NULL,
      1.035171,
      2,
      '314210',
      NULL,
      ' 3-16-1988',
      26,
      36,
      NULL,
      NULL,
      NULL,
      2.419221,
      1,
      1,
      1,
      1,
      2.847927,
      0.407022,
      1,
      0,
      5.884895,
      1.183565,
      1.708762,
      5,
      0,
      2.804010,
      5.390887,
      1,
      1.697613,
      1,
      NULL,
      0.992851,
      1.068808,
      1,
      4.159837,
      1,
      2.222644,
      1.868484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      4.206735,
      1,
      0,
      1,
      NULL,
      3.195632,
      0,
      0,
      2.143736,
      3.565590,
      0,
      3.918194,
      1.399037,
      1.951742,
      1,
      1,
      NULL,
      0.011799,
      0,
      NULL,
      2,
      2.560798,
      NULL,
      1,
      1.691246,
      0.508937,
      NULL,
      NULL,
      0.135805,
      NULL,
      NULL,
      NULL,
      0.532907,
      5.607956,
      1,
      NULL,
      0,
      1,
      NULL,
      0.769419,
      0,
      0,
      1.594091,
      0,
      NULL,
      0.542588,
      1.709646,
      0,
      0,
      1.657798,
      NULL,
      NULL,
      1.054133,
      NULL,
      0,
      1,
      1,
      1.076620,
      1,
      0,
      4,
      NULL,
      NULL,
      1.518459,
      NULL,
      NULL,
      1.051198,
      1,
      9,
      5.281463,
      1,
      0,
      7,
      2.636853,
      3,
      2,
      NULL,
      3,
      3,
      0.586130,
      0.482665,
      NULL,
      0.555287,
      0.844822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.505856,
      NULL,
      1,
      0,
      1.321197,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.361608,
      NULL,
      NULL,
      NULL,
      NULL,
      3.150990,
      1.926782,
      3.537053,
      NULL,
      1,
      0.570717,
      9,
      0.042621,
      1.024721,
      NULL,
      NULL,
      NULL,
      0,
      0.946680,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.499001,
      NULL,
      NULL,
      0.255320,
      NULL,
      0.048418,
      0.949042,
      NULL,
      1,
      0.758626,
      1,
      NULL,
      0.475916,
      1.302210,
      1.066830,
      1,
      0.882504,
      0.524177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.456344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '30304',
      '01322',
      '',
      0,
      '',
      '',
      '',
      0.813131,
      '',
      '',
      '',
      5.337016,
      3,
      3.767404,
      0,
      2.707080,
      4,
      NULL,
      NULL,
      1);
commit;
end;
/


