set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703349';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-6-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '042',
      '23',
      51,
      19.989806,
      NULL,
      NULL,
      3,
      2,
      2,
      NULL,
      3,
      ' 6- 1-1979',
      NULL,
      33.749489,
      0.364068,
      NULL,
      2.434451,
      3.527935,
      NULL,
      1.491247,
      1.932593,
      3.817537,
      1,
      0,
      1.155675,
      1,
      7,
      0.223218,
      1,
      NULL,
      1,
      2,
      3.348055,
      0.508785,
      NULL,
      1.932465,
      1,
      0,
      2,
      1,
      4,
      0.079572,
      NULL,
      0,
      NULL,
      NULL,
      1.274163,
      NULL,
      NULL,
      0,
      1.416689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.061346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.422772,
      NULL,
      1.908481,
      2.086948,
      NULL,
      0,
      NULL,
      0,
      4.607959,
      1.331892,
      NULL,
      0.151803,
      1,
      1,
      NULL,
      0,
      NULL,
      0.609990,
      4.360470,
      0.996870,
      3.848168,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      1.824423,
      1.248065,
      0,
      NULL,
      1,
      7,
      1.090419,
      4.390065,
      3,
      1.456071,
      3.300657,
      0,
      NULL,
      0,
      7,
      NULL,
      2,
      3.128082,
      NULL,
      1.535328,
      0,
      2.597645,
      0.946549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.002686,
      1,
      1,
      NULL,
      1.086596,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.712245,
      NULL,
      3,
      1,
      1,
      9.499007,
      2.039363,
      1.524271,
      NULL,
      1,
      1,
      7.004733,
      NULL,
      1.845363,
      NULL,
      NULL,
      NULL,
      1,
      1.498385,
      5.511692,
      NULL,
      0.803016,
      1,
      1.742561,
      NULL,
      NULL,
      NULL,
      1,
      4.901070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.422975,
      3,
      3.101886,
      0,
      3,
      0,
      3,
      1,
      1,
      0,
      1.914881,
      0.345222,
      0,
      1,
      1.567623,
      NULL,
      0.387441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '14331',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      2.560906,
      3,
      4.895410,
      0.311172,
      2,
      0,
      3);
commit;
end;
/


