set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703349';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '300',
      '00111004',
      NULL,
      17,
      NULL,
      29,
      6,
      1,
      NULL,
      '212110',
      2.436363,
      ' 1- 2-1998',
      12,
      26.310487,
      0.649815,
      NULL,
      NULL,
      1.006068,
      1,
      0,
      0.943596,
      2.969194,
      0.458674,
      0,
      1,
      1,
      3.290281,
      0.118241,
      1,
      NULL,
      0,
      NULL,
      4.761030,
      1,
      1,
      0.540593,
      NULL,
      0,
      3.521138,
      NULL,
      5.895527,
      3,
      1,
      1.539585,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.630784,
      NULL,
      1.625520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.406929,
      1,
      1,
      0.535645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      0,
      1.290165,
      1,
      1.578027,
      0.024016,
      0,
      1.701738,
      1.382126,
      1,
      0,
      0,
      0,
      1.800646,
      NULL,
      0,
      0.900163,
      NULL,
      0,
      2,
      2,
      0,
      0.565746,
      1,
      5,
      1,
      0.058193,
      0,
      1.761002,
      1.224715,
      NULL,
      0.873591,
      1.042923,
      NULL,
      NULL,
      NULL,
      2.457456,
      2.510272,
      6,
      6,
      NULL,
      1.966352,
      7,
      NULL,
      1,
      2,
      2,
      0,
      1,
      4,
      0.413033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.433928,
      0.414545,
      0.436518,
      0.345876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.717644,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      0.324845,
      1.619543,
      3,
      9.857723,
      3.439667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.693417,
      1,
      0,
      0.715392,
      0,
      0.139037,
      NULL,
      NULL,
      NULL,
      0,
      2.346930,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.057852,
      NULL,
      1.272141,
      0.633811,
      3.233990,
      2.596945,
      3,
      3.206691,
      0,
      NULL,
      0,
      1.636156,
      1.882322,
      1.498944,
      0,
      1,
      1.756073,
      1,
      1.078411,
      1.038611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.686245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.417509,
      '11144',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1.884463,
      '',
      NULL,
      '',
      1.347811,
      2,
      1,
      2,
      NULL,
      2,
      0,
      1,
      1);
commit;
end;
/


