set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703349';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '000',
      '00130132',
      4,
      NULL,
      '4144200',
      7,
      2,
      NULL,
      2,
      '313201',
      4,
      ' 5-15-1996',
      9,
      NULL,
      1.191660,
      NULL,
      0.000284,
      1.385499,
      0.812398,
      NULL,
      1,
      NULL,
      3.415224,
      0.143958,
      NULL,
      1.141112,
      6.122058,
      1,
      1.800612,
      0,
      NULL,
      NULL,
      4,
      1,
      NULL,
      1,
      NULL,
      NULL,
      7,
      0,
      NULL,
      NULL,
      3.712882,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.664251,
      NULL,
      0.036505,
      1.595660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.935850,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.213116,
      2.029016,
      NULL,
      5.445224,
      NULL,
      1.741954,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      0.756002,
      1.591376,
      0.805180,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.018986,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.713153,
      1,
      0.714055,
      0,
      1,
      4,
      5,
      6,
      1,
      4.155671,
      2,
      7,
      5.756791,
      9.452383,
      1.246750,
      2,
      NULL,
      0,
      1,
      NULL,
      1.127718,
      NULL,
      0.405196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.827447,
      1,
      1,
      0,
      NULL,
      0,
      1.999715,
      1.125270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.439986,
      NULL,
      NULL,
      NULL,
      NULL,
      0.131277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.994689,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      3,
      NULL,
      1,
      0.735565,
      NULL,
      NULL,
      NULL,
      1.821079,
      3.777001,
      1.536467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.468939,
      1.339412,
      0,
      0.379874,
      0.560117,
      1.187795,
      1.312595,
      0,
      0.651188,
      3.117148,
      1,
      1.029556,
      NULL,
      1.704067,
      1.545305,
      1.516455,
      1.516091,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.330180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.749975,
      '32241',
      NULL,
      '',
      0.393996,
      '',
      '',
      '',
      0.153804,
      '',
      '',
      '',
      4,
      NULL,
      2,
      3,
      4,
      2,
      0,
      1,
      2.616407);
commit;
end;
/


