set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703349';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2333',
      '20103240',
      NULL,
      15,
      NULL,
      NULL,
      1,
      1.944920,
      0,
      NULL,
      1,
      NULL,
      33.468933,
      47.717304,
      1,
      NULL,
      0.710587,
      1.690230,
      0,
      0,
      0,
      1.857891,
      NULL,
      1,
      0,
      0,
      2,
      1.694052,
      0,
      1,
      1.150279,
      0.461266,
      1.980839,
      0.596071,
      0,
      1,
      0,
      1,
      5,
      0,
      3,
      2.508354,
      2.914261,
      0.326969,
      NULL,
      NULL,
      1.333527,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.902892,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.100795,
      0,
      0,
      0.352452,
      0,
      0.122036,
      0,
      NULL,
      NULL,
      1.958797,
      1.375624,
      1.062851,
      1.018131,
      0,
      1,
      NULL,
      1,
      1.871991,
      0,
      NULL,
      0,
      1.428596,
      NULL,
      1,
      NULL,
      1.192477,
      0.827307,
      NULL,
      0.510696,
      0,
      0,
      1,
      1,
      1.382015,
      1,
      2,
      NULL,
      NULL,
      1.444498,
      4.464748,
      1.161488,
      1,
      NULL,
      0.670409,
      1,
      NULL,
      NULL,
      2,
      0.682168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.121893,
      0,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.955682,
      NULL,
      NULL,
      NULL,
      NULL,
      1.389255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.028872,
      3,
      1.564341,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.368962,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.898154,
      0.085834,
      1.869304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.836075,
      0.842737,
      2.309386,
      0.408357,
      0,
      1.777797,
      1.700965,
      NULL,
      NULL,
      0.709351,
      1.753895,
      NULL,
      0.343047,
      0.324458,
      1.193295,
      NULL,
      0.112897,
      0,
      1.057505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.663740,
      '22440',
      '',
      '',
      1,
      '',
      '',
      '',
      0.717914,
      '',
      '',
      '',
      1.736156,
      NULL,
      3.058794,
      2,
      1,
      0.554633,
      0,
      NULL,
      NULL);
commit;
end;
/


