set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703349';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4240',
      '10124043',
      NULL,
      NULL,
      '2303233',
      NULL,
      3,
      NULL,
      NULL,
      '031021',
      1.080353,
      ' 0-23-2002',
      15,
      NULL,
      0,
      NULL,
      0.583163,
      0.559006,
      0.643719,
      0.085787,
      1,
      1.931345,
      0.089752,
      1,
      NULL,
      1,
      0,
      NULL,
      0.240671,
      NULL,
      0,
      1.170395,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      2,
      2.546689,
      NULL,
      NULL,
      NULL,
      0.588033,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.421093,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.319934,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.190218,
      1,
      1.857312,
      1,
      1.095678,
      1.768718,
      1.493803,
      1.922456,
      1,
      NULL,
      0,
      1.732664,
      1.917305,
      NULL,
      0,
      NULL,
      1,
      1.022697,
      0,
      NULL,
      0,
      0.209962,
      NULL,
      NULL,
      0.831159,
      1.839820,
      1,
      0,
      3.464180,
      NULL,
      3.118006,
      1.197310,
      0.827081,
      2.146879,
      0,
      NULL,
      5,
      5,
      1.162550,
      NULL,
      NULL,
      1,
      1.040377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.589859,
      1,
      1,
      1,
      1,
      NULL,
      1.584518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.329306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.637893,
      NULL,
      1.682097,
      NULL,
      NULL,
      NULL,
      1,
      0.811905,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.275414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.697006,
      3,
      0.083465,
      1.971221,
      2,
      1.086578,
      0,
      1.602706,
      0,
      NULL,
      NULL,
      0,
      1.960681,
      0,
      1.833821,
      1,
      NULL,
      1.588201,
      1,
      1.277283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '01430',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1.141450,
      '',
      '',
      '',
      3,
      0.462912,
      1.610640,
      1,
      NULL,
      2.984387,
      3,
      1.904189,
      2);
commit;
end;
/


