set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531493';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4034',
      '20132411',
      NULL,
      NULL,
      '4143300',
      NULL,
      NULL,
      0,
      NULL,
      '323014',
      4.456825,
      '10- 6-1984',
      9,
      3,
      1,
      NULL,
      3.842145,
      1.580810,
      1.016753,
      0,
      NULL,
      NULL,
      0,
      3.996891,
      NULL,
      0.599492,
      NULL,
      1.088243,
      0.946033,
      NULL,
      0.553231,
      1,
      1,
      NULL,
      1.066291,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.678731,
      1,
      1.582588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.976375,
      0.381346,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.835544,
      NULL,
      1.467273,
      1,
      NULL,
      0,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      0.667574,
      0.051704,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.155780,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.896968,
      1,
      1,
      1.787974,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.783823,
      1,
      0,
      NULL,
      1.234636,
      1.707040,
      0,
      NULL,
      1.305091,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0.659092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.037527,
      NULL,
      NULL,
      NULL,
      NULL,
      0.124551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.030767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.775728,
      1.578376,
      1.615358,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.476362,
      1.961934,
      0.699418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.654947,
      0.434356,
      0.290639,
      NULL,
      1.986102,
      0.599415,
      0,
      0.177924,
      1.995552,
      0,
      NULL,
      1,
      0.526918,
      0,
      0.115579,
      NULL,
      0,
      1,
      1.128945,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '10340',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      6.031311,
      3,
      NULL,
      2.381755,
      3.739049,
      3,
      NULL,
      0,
      1.397063);
commit;
end;
/


