set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7907117';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '444',
      '01204344',
      13,
      21,
      '4203022',
      NULL,
      6,
      2,
      2,
      '424303',
      5,
      NULL,
      50.495432,
      NULL,
      1.521621,
      NULL,
      0,
      0,
      3,
      1,
      0,
      0,
      NULL,
      2.098702,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1.229953,
      0.059252,
      0,
      1.961426,
      0,
      0.139021,
      0.377226,
      1.476680,
      1.830389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.549002,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.576330,
      1.961253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.448988,
      1.584287,
      NULL,
      1.103593,
      NULL,
      1.952580,
      1.735465,
      0.852444,
      1.344744,
      0.054319,
      1,
      1,
      0,
      1.008637,
      NULL,
      1,
      NULL,
      NULL,
      1.287933,
      NULL,
      1.479136,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      2.301311,
      NULL,
      NULL,
      NULL,
      NULL,
      0.686429,
      NULL,
      0.682388,
      NULL,
      0,
      1,
      0,
      1.757350,
      4.047880,
      1,
      NULL,
      1.714239,
      5.485110,
      0,
      NULL,
      NULL,
      1.748327,
      NULL,
      NULL,
      NULL,
      1.964691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.347035,
      0,
      1,
      NULL,
      1,
      0.086104,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.088062,
      NULL,
      NULL,
      NULL,
      NULL,
      0.066680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.016976,
      1,
      2.609606,
      0.585073,
      3.459170,
      1,
      0.094051,
      0,
      NULL,
      1.976818,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.701196,
      1,
      1.866053,
      1.183619,
      NULL,
      NULL,
      1,
      1.856239,
      1.896009,
      2,
      0,
      0.591768,
      0,
      1,
      0,
      1.797612,
      0,
      1,
      0.217204,
      0.303406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.870223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.852996,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.399241,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      '40141',
      '20341',
      '10121',
      0.146784,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0.690420,
      0,
      NULL,
      0.246674,
      2.782548,
      0.090243,
      2,
      1.882036,
      1);
commit;
end;
/


