set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7907117';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '220',
      '44111123',
      17.462575,
      30,
      '3110140',
      2.503558,
      6,
      0.034985,
      3,
      '401331',
      1,
      ' 1- 7-1976',
      20.685802,
      55.098259,
      1,
      NULL,
      1,
      NULL,
      2,
      1.885986,
      0,
      0,
      1,
      3.419641,
      NULL,
      0,
      0,
      0,
      NULL,
      1.747968,
      1,
      0.654095,
      0.561205,
      1,
      0.609992,
      0,
      NULL,
      0,
      0.232592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.165868,
      0.952344,
      1.630094,
      1.395752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.817445,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.297807,
      1.385553,
      1.552402,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.162991,
      0,
      NULL,
      1,
      0,
      0,
      1,
      0.455540,
      0.651685,
      0.450534,
      NULL,
      0,
      1.963480,
      1.276494,
      1.989403,
      NULL,
      0,
      0.883552,
      0.626121,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.989467,
      0,
      1.872330,
      1,
      NULL,
      NULL,
      1,
      0.699141,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3.213735,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.576817,
      1,
      0,
      NULL,
      1.438075,
      0.519347,
      1.871557,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.966591,
      2.370448,
      NULL,
      0.424687,
      2.635934,
      0.353134,
      1.095567,
      2.908992,
      1.091708,
      1.476543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.714524,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.139674,
      1,
      NULL,
      1,
      1,
      1,
      1,
      0,
      0.857559,
      0.896960,
      0,
      1.932138,
      0,
      1.070715,
      1.449068,
      0.667631,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.123521,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.865268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.873995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.343849,
      2,
      NULL,
      9,
      NULL,
      1,
      NULL,
      0,
      5.938249,
      NULL,
      '22030',
      NULL,
      1,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      1.880497,
      2.036172,
      1.052041,
      0.077476,
      NULL,
      NULL,
      3,
      0.775173,
      3.789458);
commit;
end;
/


