set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7907117';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-3-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '044',
      '21024404',
      42.490919,
      56.825234,
      NULL,
      11.860815,
      0,
      1.254744,
      3,
      '211410',
      0.473342,
      ' 7- 2-1997',
      21,
      15.957940,
      0,
      NULL,
      0.310109,
      1,
      2,
      1.624513,
      1,
      NULL,
      1.280713,
      3.762684,
      NULL,
      1,
      NULL,
      1.344836,
      NULL,
      NULL,
      0,
      1.860706,
      1.904517,
      1,
      1,
      0,
      NULL,
      0.089463,
      0.964055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.885803,
      0,
      1.979388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263742,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.183303,
      0.085930,
      NULL,
      0.618647,
      NULL,
      1.421787,
      1.663771,
      1,
      0.902937,
      0.058622,
      1,
      NULL,
      1.011393,
      0.285241,
      1,
      0,
      1.197837,
      1,
      0.511870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.368042,
      0,
      0,
      1.177819,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      2.507398,
      4.836346,
      5.105340,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      0.932093,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.826010,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.709357,
      NULL,
      1,
      0,
      0,
      1.879149,
      NULL,
      NULL,
      NULL,
      0,
      0.526569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.839263,
      1.510858,
      0,
      0,
      1,
      0,
      NULL,
      1.437841,
      NULL,
      1.219173,
      0,
      NULL,
      0.954642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.327656,
      0.910757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.119165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.670198,
      NULL,
      NULL,
      NULL,
      NULL,
      1.262631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.866183,
      3,
      3,
      0,
      1.455055,
      1,
      0,
      '42331',
      '42342',
      NULL,
      1.914992,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      1.146607,
      3,
      NULL,
      5.684033,
      3.894101,
      NULL,
      0.652110,
      NULL);
commit;
end;
/


