set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7907117';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '204',
      '34041300',
      79,
      17.031316,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '340011',
      3,
      ' 9-17-1979',
      NULL,
      17,
      1.880055,
      NULL,
      1,
      2,
      0,
      0,
      0,
      0,
      0.236774,
      0.743122,
      1,
      NULL,
      1.517614,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0.062634,
      0.249388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.325793,
      0.403543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.918123,
      NULL,
      NULL,
      0.291212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.641761,
      0.236042,
      0,
      1.878475,
      NULL,
      0,
      0,
      NULL,
      0.048233,
      1.609856,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.008981,
      0.685951,
      0.782055,
      0,
      1,
      1,
      NULL,
      1,
      1.504369,
      0.360494,
      0,
      NULL,
      0.032600,
      0.537492,
      0,
      NULL,
      NULL,
      0.973460,
      NULL,
      0.185514,
      NULL,
      0.732341,
      0.783563,
      NULL,
      NULL,
      0,
      0,
      3,
      1,
      NULL,
      NULL,
      2,
      0.939996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.495858,
      1,
      1,
      0.137499,
      1,
      0.265717,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.783199,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.305615,
      0,
      NULL,
      NULL,
      NULL,
      1.432508,
      1.511743,
      1.529170,
      NULL,
      NULL,
      0,
      0.240805,
      NULL,
      NULL,
      NULL,
      NULL,
      1.772306,
      0.724597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.043111,
      0,
      NULL,
      1,
      NULL,
      0.938304,
      0,
      NULL,
      1,
      2.233420,
      1.867073,
      1.804784,
      NULL,
      0.283072,
      0.297849,
      1.243483,
      1.457500,
      NULL,
      0,
      1.261176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.940346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.866367,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.993681,
      NULL,
      1.495320,
      0,
      1,
      NULL,
      NULL,
      '01440',
      '33213',
      '10422',
      1.099152,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      NULL,
      3.650396,
      2.214540,
      5,
      0.692190,
      2.010417,
      3,
      0);
commit;
end;
/


