set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '341',
      NULL,
      NULL,
      33,
      '1412140',
      160,
      3,
      3.158986,
      0,
      '012032',
      NULL,
      ' 9-20-1986',
      52,
      43.642466,
      0,
      NULL,
      1.618806,
      1,
      3,
      0.160827,
      0,
      1,
      0.182780,
      0,
      0,
      0.943481,
      0.245295,
      NULL,
      1,
      0.810348,
      0.563971,
      1.648251,
      NULL,
      NULL,
      NULL,
      1.706046,
      1.343493,
      0.832830,
      0.891822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.414143,
      0.128698,
      NULL,
      0.267558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.095317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.770482,
      NULL,
      0,
      NULL,
      0,
      1.579776,
      0,
      0.076917,
      1,
      0,
      0,
      0,
      1.574446,
      1,
      1.088840,
      1.947978,
      NULL,
      1.074389,
      1.672984,
      NULL,
      0.437269,
      1.388949,
      0,
      NULL,
      1.632955,
      0,
      1.958345,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.363814,
      1.875239,
      0.553005,
      0,
      1.200140,
      0.113843,
      0.189875,
      2.465016,
      NULL,
      NULL,
      2.541668,
      0.769013,
      1.127984,
      0,
      NULL,
      1,
      NULL,
      NULL,
      8.578479,
      1.779318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.800101,
      1.338021,
      0,
      0,
      1,
      1.692879,
      1.055752,
      1.579492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.471730,
      0,
      NULL,
      NULL,
      NULL,
      0.671291,
      4.060321,
      4,
      5.844476,
      0.428571,
      0,
      1.215923,
      NULL,
      NULL,
      NULL,
      0,
      1.160675,
      1.791381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.023798,
      1.454329,
      1,
      1,
      0.267882,
      NULL,
      0,
      0,
      1,
      1,
      0,
      NULL,
      1.267343,
      0.525600,
      0.311392,
      0.177076,
      NULL,
      NULL,
      0.962474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.656291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.074897,
      '30024',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      0,
      3.737002,
      NULL,
      1,
      3.882187,
      NULL,
      3.439580,
      2,
      0);
commit;
end;
/


