set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '242',
      '12134243',
      NULL,
      37.610605,
      '0130131',
      30.805854,
      NULL,
      2,
      3,
      '421430',
      2,
      ' 9-22-1984',
      4.152483,
      54.329599,
      1,
      NULL,
      0,
      0,
      3,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      0,
      NULL,
      0.974454,
      1.015559,
      0.464884,
      0,
      0,
      1.141559,
      1,
      NULL,
      0,
      1,
      0.174595,
      0.961873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.056460,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.938812,
      0.334461,
      0.769530,
      1.020450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.139026,
      1.648966,
      1.134427,
      1.603292,
      1.920463,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.326538,
      1.824014,
      0,
      0,
      0.023607,
      1,
      1.035310,
      0,
      NULL,
      1.718635,
      NULL,
      1.056663,
      3,
      1.193108,
      1.552584,
      NULL,
      3.584101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.631534,
      NULL,
      NULL,
      NULL,
      0.488844,
      1,
      1.914845,
      1.664933,
      4,
      5.049070,
      3,
      1,
      0.296847,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      1,
      1.564951,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.574202,
      NULL,
      NULL,
      NULL,
      NULL,
      0.641516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.650401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.233722,
      NULL,
      5.637594,
      1.967333,
      0.117459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.950715,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.137519,
      0.358731,
      0.377221,
      NULL,
      0,
      0.041451,
      1.010478,
      1.360152,
      1.579301,
      0,
      1.758284,
      0,
      1.750295,
      1,
      1,
      1,
      0.811113,
      0.938439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.549883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '34300',
      '',
      '',
      0.335506,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3.351780,
      0,
      3,
      NULL,
      NULL,
      3.416915,
      2,
      2,
      1.306095);
commit;
end;
/


