set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9112150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-12-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '01',
      12,
      19.863462,
      '4013410',
      NULL,
      0,
      1.840506,
      1,
      '133341',
      NULL,
      ' 6-21-1975',
      35.844523,
      18.962509,
      0,
      NULL,
      NULL,
      NULL,
      2.135798,
      0.569904,
      0.741882,
      NULL,
      0.550941,
      NULL,
      NULL,
      0.279442,
      2.116232,
      1.964885,
      0,
      1.421295,
      NULL,
      0.525055,
      3,
      NULL,
      0.903056,
      0,
      1.566538,
      1,
      4.898293,
      1,
      2.021915,
      0.978299,
      0.027046,
      NULL,
      NULL,
      NULL,
      0.669187,
      NULL,
      NULL,
      1,
      0.728627,
      1.146145,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.950011,
      1.412780,
      1.304817,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      1,
      1.972551,
      0,
      0,
      1,
      1,
      7,
      4.359888,
      1,
      1.798046,
      NULL,
      1,
      NULL,
      NULL,
      1.466659,
      1.225127,
      NULL,
      0,
      0.246961,
      0.181783,
      0,
      1,
      0.623658,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.293461,
      NULL,
      1,
      0.440667,
      0,
      3.016468,
      5.301428,
      2,
      NULL,
      NULL,
      3,
      5,
      7.428447,
      1,
      0,
      1.145445,
      2,
      0.949077,
      1,
      8.621018,
      1.010515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      0.630857,
      1.711494,
      0.615744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.124366,
      1,
      3,
      1.752029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.945582,
      NULL,
      2,
      2,
      1.997336,
      1,
      0.530361,
      NULL,
      5.578649,
      NULL,
      2,
      1,
      4.267187,
      0,
      NULL,
      NULL,
      2.498691,
      1,
      0.217590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.310793,
      3.297724,
      2.064341,
      0.763769,
      3.610202,
      1.272331,
      0,
      3.385365,
      1,
      1,
      0.711426,
      0.371161,
      0,
      0.851250,
      1.398196,
      0,
      NULL,
      0.980215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.966845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.183020,
      '1022',
      '24032',
      '',
      0.564260,
      '34114',
      NULL,
      '',
      5,
      '0440',
      '1032',
      '',
      1.650408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


