set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9112150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '212',
      NULL,
      34,
      23.318182,
      '1420323',
      147,
      1,
      0,
      3,
      NULL,
      0.005804,
      ' 3-26-1991',
      36.291793,
      40.322445,
      0,
      NULL,
      0.157295,
      3.532671,
      1,
      1.402333,
      1,
      1.577403,
      0.695167,
      1,
      2.515692,
      0,
      1,
      NULL,
      1,
      0,
      0.192859,
      1,
      NULL,
      1.996033,
      1,
      1,
      1.038624,
      1.182864,
      3.565393,
      0,
      NULL,
      0.879735,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.285476,
      NULL,
      0.299297,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.523137,
      0.686327,
      1,
      4,
      1,
      1,
      NULL,
      5.018788,
      NULL,
      NULL,
      0.397262,
      1.747476,
      1,
      1,
      0,
      1,
      1.466832,
      NULL,
      0.198309,
      1.539213,
      0.596627,
      0,
      0.375204,
      0.547469,
      1.966857,
      0,
      1,
      1,
      1,
      0.274624,
      0.381958,
      0.097076,
      0.844774,
      0.608843,
      1.891795,
      1,
      2,
      2.402776,
      2.133001,
      3.177998,
      0.115962,
      0.176014,
      NULL,
      1.582742,
      1,
      1.430435,
      0.592367,
      0,
      0,
      8,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.207317,
      1,
      1,
      NULL,
      0.731791,
      0,
      0.832602,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.640888,
      NULL,
      9,
      0,
      0,
      4.752217,
      3,
      0,
      1,
      1.241676,
      0,
      5,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.358431,
      NULL,
      5,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      1.006571,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.783182,
      NULL,
      2.448467,
      0.850171,
      NULL,
      0,
      0.224263,
      1.918830,
      1,
      NULL,
      0.759615,
      0,
      0.621934,
      1,
      1,
      NULL,
      1,
      1,
      0.874317,
      0.185981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '02401',
      '2241',
      NULL,
      1.229244,
      '',
      NULL,
      '',
      1,
      '2003',
      '0201',
      '',
      5,
      3.104394,
      0,
      2.631614,
      0.970708,
      2.789092,
      2.898584,
      1.894957,
      0.811095);
commit;
end;
/


