set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9112150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '204',
      '24023324',
      48,
      NULL,
      NULL,
      5,
      0,
      2,
      0,
      '201104',
      NULL,
      ' 2- 1-1996',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.020185,
      NULL,
      0.063332,
      1.906028,
      0.452847,
      NULL,
      3.459664,
      0.152838,
      1.160775,
      0.796813,
      1,
      0.951072,
      1.944557,
      1.694699,
      5.913753,
      1.776578,
      0,
      0,
      1,
      0.499494,
      1.632043,
      0,
      3.826580,
      NULL,
      NULL,
      1.243068,
      NULL,
      NULL,
      1.729265,
      NULL,
      NULL,
      0,
      1.328994,
      1.451982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.997970,
      3.445145,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.128895,
      5.939435,
      4,
      1.472961,
      1,
      0.424764,
      1,
      2.467097,
      0.966768,
      1.615605,
      7.167049,
      0.360062,
      0.679143,
      0,
      0.081621,
      0.151925,
      NULL,
      1,
      0,
      0,
      1,
      0.361441,
      NULL,
      1.580490,
      3.964579,
      NULL,
      NULL,
      NULL,
      NULL,
      1.374582,
      NULL,
      NULL,
      1,
      1,
      3,
      7,
      4.256356,
      1,
      0.320038,
      2.044430,
      0.690146,
      NULL,
      1.124028,
      0,
      NULL,
      2.682369,
      0.095568,
      1,
      4.506105,
      0.969731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.588890,
      0,
      1,
      1,
      0.903982,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.136954,
      NULL,
      1.757750,
      3,
      2.372502,
      NULL,
      NULL,
      2,
      1.657854,
      0,
      NULL,
      2,
      3,
      1.730575,
      NULL,
      NULL,
      NULL,
      2,
      1.014879,
      1.167597,
      NULL,
      0.929927,
      1,
      3,
      0.555261,
      NULL,
      NULL,
      1,
      5.756859,
      1.748543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      0,
      2,
      0,
      1.801290,
      NULL,
      0,
      3,
      1,
      0,
      1.598152,
      1.577518,
      1,
      0.676898,
      NULL,
      1,
      0.070450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.908322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.006022,
      '12311',
      NULL,
      NULL,
      0.341166,
      '',
      '',
      '',
      6.098729,
      '0143',
      '110',
      '403',
      3.122318,
      NULL,
      3,
      3.798119,
      2.172573,
      3.172553,
      2,
      1.994308,
      2.397249);
commit;
end;
/


