set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9112150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0204',
      '23024031',
      3,
      NULL,
      '0243221',
      187.339590,
      3,
      NULL,
      NULL,
      '343204',
      3,
      ' 2- 0-1998',
      17.125039,
      NULL,
      NULL,
      NULL,
      0.481973,
      3.108533,
      1.652796,
      NULL,
      1.567224,
      0,
      1.612889,
      1,
      NULL,
      1,
      0,
      0.369614,
      0.771125,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1,
      1,
      1.754619,
      4.208561,
      NULL,
      2,
      NULL,
      0.017758,
      0.525226,
      NULL,
      NULL,
      1.633009,
      NULL,
      NULL,
      3.038538,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.921731,
      0.626263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.710234,
      3,
      NULL,
      2,
      1.356280,
      0.289869,
      0.459497,
      1.910379,
      NULL,
      0.387038,
      NULL,
      1,
      1.917010,
      NULL,
      1,
      1.172443,
      0,
      NULL,
      NULL,
      0.476931,
      0.298044,
      0,
      0.049481,
      0,
      1.741557,
      0.578035,
      1,
      NULL,
      1.502711,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.980767,
      NULL,
      0.680072,
      2,
      NULL,
      6.926527,
      1.305042,
      6.940128,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.249276,
      0.001847,
      NULL,
      1,
      0,
      0.858411,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.290025,
      1.403370,
      0.198407,
      1,
      NULL,
      2.479587,
      NULL,
      0,
      NULL,
      2.125774,
      1.621200,
      0.151793,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.713739,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.942551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.180231,
      1,
      3.735657,
      1,
      0,
      3.874991,
      3.504431,
      1.943795,
      NULL,
      2,
      1.902898,
      0,
      0.792433,
      1.712439,
      1,
      1.674951,
      0,
      0.433556,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.797817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      '12341',
      '0403',
      '30041',
      1,
      '',
      '',
      '',
      7,
      '0031',
      '301',
      '4240',
      5.085447,
      4,
      2.933462,
      6,
      NULL,
      5,
      1.350320,
      0,
      3.001511);
commit;
end;
/


