set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9112150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3341',
      '21222021',
      36,
      NULL,
      '3334024',
      87.180102,
      NULL,
      0,
      0,
      '411321',
      NULL,
      ' 7-16-1990',
      37.323951,
      0,
      0,
      NULL,
      1,
      1,
      3.434179,
      0.989733,
      1,
      NULL,
      1,
      1.449370,
      NULL,
      1.811709,
      NULL,
      1,
      1.243195,
      1,
      1,
      0,
      NULL,
      0.993734,
      0,
      0.292356,
      0,
      1.303655,
      3,
      0,
      4,
      1.451981,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      0.736387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.056041,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4.703855,
      1,
      2,
      1,
      2,
      1,
      0,
      0.375623,
      3.912922,
      NULL,
      0,
      2,
      NULL,
      0.471865,
      1.068031,
      0.206988,
      0,
      NULL,
      0,
      1,
      0,
      1.221066,
      0.098901,
      1.012722,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.204484,
      2,
      NULL,
      NULL,
      1.467532,
      1,
      3.300438,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.106145,
      0.780119,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.272216,
      1.346421,
      NULL,
      1,
      1,
      1.888881,
      0.080018,
      0.707057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      7.088346,
      2,
      2,
      7.909646,
      0,
      NULL,
      1.614231,
      NULL,
      2,
      3.469212,
      3,
      0.407231,
      NULL,
      NULL,
      NULL,
      1.216382,
      0.966752,
      NULL,
      NULL,
      1.863117,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.988452,
      NULL,
      0.472189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.785934,
      2.028062,
      0,
      0,
      0.712285,
      2.196311,
      NULL,
      2.190588,
      0.902482,
      1.134220,
      NULL,
      NULL,
      NULL,
      0.827906,
      1.265222,
      1,
      1.891064,
      0.239630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '4334',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      '3023',
      '0403',
      NULL,
      0,
      0,
      1.488654,
      3,
      0.545330,
      3.710839,
      2.713373,
      2,
      0.895359);
commit;
end;
/


