set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9112150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4131',
      NULL,
      1,
      44.001844,
      NULL,
      152.575592,
      NULL,
      3,
      NULL,
      '114303',
      3.728837,
      ' 8-11-1979',
      NULL,
      29.035143,
      1.952247,
      NULL,
      0,
      1,
      3,
      0,
      0.732120,
      1.507505,
      0.782654,
      NULL,
      3.704120,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.197266,
      0.449632,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      2.844220,
      0,
      0.235466,
      NULL,
      NULL,
      NULL,
      0.718247,
      NULL,
      NULL,
      1.569432,
      0.537199,
      0.007097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.947908,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.023476,
      NULL,
      4.568104,
      1.749046,
      NULL,
      5,
      1.068154,
      0.627013,
      NULL,
      5,
      0.550649,
      1,
      1.062184,
      5,
      0,
      1,
      0,
      NULL,
      0.354202,
      NULL,
      0.254165,
      1,
      0.403245,
      1,
      1,
      0.651417,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1.998831,
      0,
      5.248045,
      0,
      NULL,
      NULL,
      NULL,
      3.278279,
      8.838042,
      6.837344,
      1.689990,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.242181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.813572,
      0,
      1,
      1,
      1.382541,
      1.761244,
      0,
      1.265979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      7,
      1.431827,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      4.077652,
      0,
      NULL,
      1,
      1.634977,
      0,
      4.093711,
      0,
      NULL,
      NULL,
      1,
      0.150198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.006064,
      0,
      1.181571,
      1,
      1.005224,
      0,
      0,
      1.395101,
      1.591257,
      1.813632,
      0.736373,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7,
      '12244',
      '3214',
      '13343',
      1.062699,
      '',
      NULL,
      '',
      3,
      '1121',
      '',
      '',
      5.060329,
      2,
      NULL,
      3.127414,
      2,
      0,
      0.894951,
      2,
      3.649912);
commit;
end;
/


