set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9112150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1334',
      '10200144',
      57.691304,
      44.702023,
      '1410204',
      NULL,
      NULL,
      3,
      3,
      NULL,
      5.653791,
      ' 2-24-1978',
      4,
      22.614906,
      0,
      NULL,
      1.635694,
      1,
      NULL,
      NULL,
      0.170188,
      0,
      1,
      NULL,
      1.150134,
      0,
      1.221784,
      1,
      NULL,
      0.454578,
      0,
      0,
      5,
      NULL,
      0.948953,
      0,
      1.615729,
      0,
      1.007774,
      NULL,
      1,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.274929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.827351,
      0.279481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.758076,
      1,
      NULL,
      1,
      3,
      1,
      1.033900,
      0,
      0.562983,
      1.356893,
      NULL,
      NULL,
      1,
      5.202640,
      0,
      0.288255,
      1,
      NULL,
      0.244518,
      NULL,
      1,
      1,
      1,
      0,
      0.496392,
      1,
      1.682662,
      0.581163,
      NULL,
      NULL,
      NULL,
      NULL,
      4.062430,
      0.827341,
      2,
      NULL,
      0.078652,
      2,
      NULL,
      3,
      2,
      7,
      2.612100,
      1.316057,
      6,
      0,
      0,
      1.679735,
      1.466106,
      NULL,
      NULL,
      2,
      1.512456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      1.554133,
      1.222348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.725026,
      NULL,
      7.169837,
      2.524569,
      0,
      1.438337,
      NULL,
      NULL,
      2.315579,
      1.931594,
      0.317428,
      NULL,
      NULL,
      1.248204,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.323070,
      5,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0.239588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.345215,
      3.285276,
      3.625496,
      3,
      2,
      NULL,
      NULL,
      NULL,
      3.179162,
      0,
      NULL,
      0.931535,
      NULL,
      1,
      0,
      0,
      0,
      1.502396,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.672564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7.698899,
      '12122',
      '0043',
      '10022',
      1,
      '',
      '',
      '',
      NULL,
      '0030',
      '4221',
      '',
      1.460437,
      NULL,
      0.370855,
      3.039345,
      4,
      3.014217,
      1,
      2,
      NULL);
commit;
end;
/


