set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9112150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '04241130',
      41,
      35,
      '1420411',
      NULL,
      5,
      NULL,
      3,
      '133441',
      0,
      '11-12-1976',
      265.099868,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.729269,
      1.499885,
      0,
      0.423009,
      0.781831,
      1,
      3.267969,
      NULL,
      1,
      NULL,
      5,
      0.374497,
      1.355711,
      0,
      1.104825,
      1,
      0.245237,
      0.417052,
      1.539585,
      NULL,
      2.055442,
      NULL,
      3,
      1,
      1,
      1.698803,
      NULL,
      NULL,
      0.958435,
      NULL,
      NULL,
      1,
      NULL,
      0.726428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.985640,
      4,
      1,
      0.883824,
      0,
      1.404205,
      1.531776,
      0,
      1,
      4,
      2,
      1.866738,
      0,
      0.886207,
      1.007794,
      1.400536,
      1.074506,
      NULL,
      NULL,
      NULL,
      1,
      0.888324,
      0,
      0.411060,
      0,
      2,
      3.521481,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2.174918,
      0.798122,
      NULL,
      0.635861,
      3.640314,
      3.163404,
      NULL,
      NULL,
      0,
      2,
      3,
      7,
      NULL,
      0,
      0,
      1.730343,
      0,
      NULL,
      NULL,
      2.019603,
      0.323882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.930266,
      1,
      0,
      1.041249,
      0.769979,
      NULL,
      1.351322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.292602,
      NULL,
      NULL,
      NULL,
      0.646836,
      7,
      2,
      NULL,
      1.365446,
      1.311649,
      2,
      4,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      6.403950,
      0,
      3,
      6,
      1,
      2.862794,
      NULL,
      NULL,
      NULL,
      1,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.516091,
      NULL,
      NULL,
      NULL,
      3,
      3.304877,
      NULL,
      0,
      1.401243,
      0,
      0,
      1,
      1,
      0.882341,
      0.680115,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.884654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      '2113',
      '44133',
      1,
      '',
      '',
      '',
      5,
      '1210',
      '2431',
      '',
      5.359145,
      3,
      1.200338,
      2,
      0,
      1.383407,
      0,
      0.375808,
      NULL);
commit;
end;
/


