set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9648262';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '022',
      '42430341',
      1.400059,
      0,
      '2002141',
      56.004487,
      3,
      NULL,
      NULL,
      '143314',
      NULL,
      NULL,
      25.884644,
      5,
      0.744530,
      NULL,
      2.558536,
      0,
      2,
      0,
      NULL,
      3.949588,
      1.094026,
      NULL,
      2,
      0,
      NULL,
      0.564082,
      1.863623,
      1.162998,
      NULL,
      1,
      NULL,
      NULL,
      0.719602,
      0,
      0.072431,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.081565,
      1.505495,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.573514,
      0.708422,
      1.733926,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.267725,
      6,
      7,
      0.972350,
      1.247968,
      3.686479,
      1.869922,
      NULL,
      0,
      1.873538,
      2,
      NULL,
      NULL,
      0.965961,
      1.752368,
      1,
      0.950578,
      0,
      NULL,
      1.041103,
      1,
      3.258565,
      0.440346,
      0,
      0,
      NULL,
      0,
      3.497192,
      0.124575,
      2,
      5,
      NULL,
      1,
      1,
      3.990612,
      4,
      0.172766,
      NULL,
      0.639328,
      6,
      5,
      7.343211,
      8,
      1.225499,
      2,
      7.086218,
      6.712057,
      1,
      1,
      1.437917,
      2.766939,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.175010,
      0,
      1,
      1,
      0.091074,
      NULL,
      5,
      2,
      1,
      2,
      1.325695,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.252188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.394889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.582413,
      1.883122,
      NULL,
      0.443344,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.496614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.490339,
      1,
      1,
      0,
      0,
      2.666154,
      NULL,
      1.327012,
      NULL,
      NULL,
      NULL,
      1,
      0.373737,
      1.453931,
      0.584741,
      1.727650,
      1.081913,
      1.798328,
      0.349121,
      0.354809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.796851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.375513,
      '0242',
      '4422',
      NULL,
      NULL,
      '',
      '',
      '',
      2.072638,
      '4143',
      '',
      '',
      4.401076,
      3,
      0.972034,
      NULL,
      1.864204,
      NULL,
      1.790007,
      1,
      2);
commit;
end;
/


