set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9648262';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '402',
      '02323033',
      26,
      22.513649,
      '3000022',
      51,
      3,
      0.738081,
      2,
      NULL,
      1,
      ' 2- 8-1998',
      40.959343,
      271,
      NULL,
      NULL,
      3.815002,
      NULL,
      0,
      1,
      0,
      2,
      1.538052,
      NULL,
      0.750916,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.350079,
      6.802635,
      1.140047,
      0,
      0,
      1,
      1.783281,
      7.190206,
      NULL,
      NULL,
      1,
      1.485656,
      0.144956,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      3.541399,
      1,
      NULL,
      NULL,
      2.666883,
      NULL,
      3,
      NULL,
      1,
      0,
      0,
      1,
      3,
      0,
      0,
      0.451411,
      1,
      NULL,
      NULL,
      0.813037,
      NULL,
      NULL,
      1,
      0,
      3,
      5.348661,
      4,
      NULL,
      NULL,
      0,
      5,
      1.577777,
      0,
      1,
      1.755284,
      4,
      1,
      0.539129,
      0.083942,
      NULL,
      NULL,
      NULL,
      1,
      1.669477,
      1.368718,
      1,
      NULL,
      1.990288,
      6.292728,
      0,
      2.959150,
      0.472859,
      4.115499,
      NULL,
      5.634312,
      0,
      2.400168,
      0.452526,
      0,
      10,
      4,
      NULL,
      NULL,
      2,
      NULL,
      3.899466,
      0,
      2.799776,
      5,
      5,
      1.169033,
      1,
      NULL,
      0,
      0.296471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.056530,
      0,
      2,
      1.511278,
      5.527109,
      NULL,
      7,
      NULL,
      5,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.962484,
      7,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.909339,
      NULL,
      2.462650,
      2,
      NULL,
      1,
      1.825608,
      1,
      NULL,
      2.039128,
      3,
      NULL,
      0.010134,
      0.869287,
      1,
      0,
      1.958672,
      NULL,
      1.260674,
      0.450571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '2430',
      '0442',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      4.409707,
      0,
      2.617364,
      0.427663,
      NULL,
      1.226509,
      3,
      2,
      3.988049);
commit;
end;
/


