set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9648262';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '11221141',
      16.952480,
      50.274900,
      '1004330',
      32,
      NULL,
      1,
      1,
      '243032',
      NULL,
      '10-27-1983',
      58.212489,
      30,
      0.355587,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1.995122,
      1.147101,
      0,
      0.603672,
      5.580075,
      0.531008,
      0,
      1.780059,
      0.741766,
      1,
      5.500519,
      1.451793,
      0,
      1.156674,
      2,
      1,
      NULL,
      0,
      4.083154,
      1.511908,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.924304,
      0,
      NULL,
      1.522687,
      0.092613,
      1.718222,
      1.697117,
      1.813452,
      NULL,
      3.862555,
      1,
      0.044165,
      1,
      3.195188,
      0,
      0,
      1.315714,
      3.795482,
      3,
      0.206322,
      1,
      9.503139,
      0,
      NULL,
      2.567808,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.833006,
      0,
      0,
      NULL,
      NULL,
      1.842936,
      1.588422,
      NULL,
      0.334693,
      1.721504,
      1,
      NULL,
      1,
      NULL,
      5,
      NULL,
      0.387218,
      0,
      NULL,
      NULL,
      3,
      0.653738,
      NULL,
      0,
      3.301109,
      NULL,
      5,
      5.625287,
      NULL,
      2,
      4,
      4.673508,
      2.194167,
      NULL,
      NULL,
      NULL,
      5.834529,
      4,
      5.047491,
      1.558952,
      2.917823,
      4.498120,
      0.120933,
      3.504302,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.320707,
      1,
      1,
      1,
      7,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.559311,
      NULL,
      NULL,
      NULL,
      NULL,
      2.686972,
      NULL,
      0,
      2,
      1,
      13,
      3,
      NULL,
      0.485789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.465198,
      NULL,
      0.722115,
      1,
      1.695430,
      1.991101,
      NULL,
      NULL,
      NULL,
      5.368744,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.403703,
      0,
      2.736216,
      1,
      1,
      NULL,
      1.064697,
      3,
      2,
      1.971434,
      0,
      0.274066,
      0.425516,
      NULL,
      1,
      0.699669,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.690624,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.461901,
      0.623763,
      1,
      0.064494,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3300',
      NULL,
      '32132',
      0.577773,
      '',
      '',
      '',
      0.280550,
      NULL,
      '',
      NULL,
      0,
      1.528711,
      1.082348,
      1,
      2.785194,
      0,
      1,
      1,
      NULL);
commit;
end;
/


