set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9648262';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '243',
      '12342142',
      58.762941,
      NULL,
      '3424132',
      18,
      NULL,
      0.791900,
      2,
      '132403',
      NULL,
      ' 9-25-1985',
      93.471216,
      NULL,
      NULL,
      NULL,
      0.666635,
      1.328160,
      1,
      NULL,
      0.256828,
      2,
      NULL,
      1,
      1,
      0.460742,
      2.526112,
      0,
      NULL,
      1.224794,
      1.060963,
      1.799985,
      NULL,
      NULL,
      NULL,
      1,
      2.418680,
      0.798552,
      1.175132,
      1,
      0,
      1,
      0.970058,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.049481,
      0,
      0.446078,
      3,
      1,
      NULL,
      NULL,
      1.109025,
      1,
      2.381310,
      3.454125,
      NULL,
      0.208688,
      1.089464,
      3,
      NULL,
      3,
      0,
      0,
      1,
      1.849082,
      NULL,
      5.986294,
      1,
      NULL,
      0,
      1.636170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      9.474914,
      NULL,
      NULL,
      0,
      6,
      0.010652,
      4,
      1.116559,
      5.183883,
      0.671280,
      1,
      5,
      1,
      1,
      0,
      0.214634,
      0,
      NULL,
      0,
      NULL,
      3,
      1.020747,
      0,
      NULL,
      4.894194,
      NULL,
      2,
      1,
      4,
      1.820707,
      0,
      1.395259,
      0,
      NULL,
      3.972169,
      5.183316,
      NULL,
      NULL,
      7.344436,
      NULL,
      0,
      4,
      5,
      4,
      4.784209,
      5.604438,
      1.024002,
      1.184694,
      1.845952,
      1.231917,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.872506,
      0,
      0,
      2,
      0,
      2,
      4.552145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.382614,
      0,
      5.067975,
      1,
      0.057621,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.189562,
      NULL,
      0.638099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.970348,
      0,
      NULL,
      1.615413,
      NULL,
      NULL,
      1,
      2,
      1,
      0,
      3.497109,
      NULL,
      0.832132,
      0.745181,
      0.180888,
      0.144657,
      1.858706,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      '3012',
      '4101',
      '02300',
      0,
      '',
      '',
      '',
      1.707633,
      NULL,
      '',
      '',
      NULL,
      0.289210,
      3.068422,
      2.868225,
      2,
      1,
      1.777180,
      2,
      1.930464);
commit;
end;
/


